untrusted comment: signature from openbsd 6.0 base secret key
RWSho3oKSqgLQ/nzEC2650yurwBzbbnaYx3TOsReydSfZLWll41aSNWKgXtjU6Fs4eUxRFKB53AlSMNUMCrYZqGwTxYm3Qf2Mgo=

OpenBSD 6.0 errata 030, August 3, 2017:

A missing length check in sys_sendsyslog() may result in a kernel panic.

Apply by doing:
    signify -Vep /etc/signify/openbsd-60-base.pub -x 030_sendsyslog.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/kern/subr_log.c
===================================================================
RCS file: /cvs/src/sys/kern/subr_log.c,v
--- sys/kern/subr_log.c	23 Jun 2016 15:41:42 -0000	1.48
+++ sys/kern/subr_log.c	2 Aug 2017 16:26:20 -0000
@@ -415,6 +415,9 @@ dosendsyslog(struct proc *p, const char 
 	size_t i, len;
 	int error;
 
+	if (nbyte > 8192)
+		nbyte = 8192;
+
 	if (syslogf)
 		FREF(syslogf);
 	else if (!ISSET(flags, LOG_CONS))
