untrusted comment: signature from openbsd 6.0 base secret key
RWSho3oKSqgLQ9TdYJa2HDKdITybCISVckLUDZO2kvMBEbWZk8CMFaXMaiAJVyplHeQt612H+qpfyzqeDTLoBKp7gY1G/DimOwE=

OpenBSD 6.0 errata 12, Oct 08, 2016:

Allocation of an amap with at least 131072 slots causes an integer overflow
that leads to an infinite loop.

Apply by doing:
    signify -Vep /etc/signify/openbsd-60-base.pub -x 012_amap.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/uvm/uvm_amap.c
===================================================================
RCS file: /cvs/src/sys/uvm/uvm_amap.c,v
retrieving revision 1.75
diff -u -p -r1.75 uvm_amap.c
--- sys/uvm/uvm_amap.c	14 Jul 2016 16:23:49 -0000	1.75
+++ sys/uvm/uvm_amap.c	8 Oct 2016 15:12:14 -0000
@@ -268,7 +268,7 @@ amap_alloc1(int slots, int waitf, int la
 {
 	struct vm_amap *amap;
 	struct vm_amap_chunk *chunk, *tmp;
-	int chunks, chunkperbucket = 1, hashshift = 0;
+	int chunks, log_chunks, chunkperbucket = 1, hashshift = 0;
 	int buckets, i, n;
 	int pwaitf = (waitf == M_WAITOK) ? PR_WAITOK : PR_NOWAIT;
 
@@ -305,8 +305,11 @@ amap_alloc1(int slots, int waitf, int la
 		 * for the hash buckets of all amaps to exceed the maximal
 		 * amount of KVA memory reserved for amaps.
 		 */
+		for (log_chunks = 1; (chunks >> log_chunks) > 0; log_chunks++)
+			continue;
+
 		chunkperbucket = 1 << hashshift;
-		while ((1 << chunkperbucket) * 2 <= chunks) {
+		while (chunkperbucket + 1 < log_chunks) {
 			hashshift++;
 			chunkperbucket = 1 << hashshift;
 		}
