untrusted comment: signature from openbsd 6.0 base secret key
RWSho3oKSqgLQ9ZFM3xIkMBu8BeBCYbv6eon/Tt9qohFeLd4eHuYMfou24e0ejr9aUDbsUt2/YzcAFxFtj4G2xexfc81z6RqpAg=

OpenBSD 6.0 errata 9, Sep 22, 2016:

Avoid falling back to a weak digest for (EC)DH when using SNI with libssl.

Apply by doing:
    signify -Vep /etc/signify/openbsd-60-base.pub -x 009_libssl.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libssl:
	cd /usr/src/lib/libssl
	make obj
	make depend
	make
	make install

Index: lib/libssl/src/ssl/ssl_lib.c
===================================================================
RCS file: /cvs/src/lib/libssl/src/ssl/Attic/ssl_lib.c,v
retrieving revision 1.116
diff -u -p -r1.116 ssl_lib.c
--- lib/libssl/src/ssl/ssl_lib.c	25 Oct 2015 15:52:49 -0000	1.116
+++ lib/libssl/src/ssl/ssl_lib.c	22 Sep 2016 17:44:12 -0000
@@ -2847,13 +2847,20 @@ SSL_get_SSL_CTX(const SSL *ssl)
 SSL_CTX *
 SSL_set_SSL_CTX(SSL *ssl, SSL_CTX* ctx)
 {
+	CERT *ocert = ssl->cert;
+
 	if (ssl->ctx == ctx)
 		return (ssl->ctx);
 	if (ctx == NULL)
 		ctx = ssl->initial_ctx;
-	if (ssl->cert != NULL)
-		ssl_cert_free(ssl->cert);
 	ssl->cert = ssl_cert_dup(ctx->cert);
+	if (ocert != NULL) {
+		int i;
+		/* Copy negotiated digests from original certificate. */
+		for (i = 0; i < SSL_PKEY_NUM; i++)
+			ssl->cert->pkeys[i].digest = ocert->pkeys[i].digest;
+		ssl_cert_free(ocert);
+	}
 	CRYPTO_add(&ctx->references, 1, CRYPTO_LOCK_SSL_CTX);
 	SSL_CTX_free(ssl->ctx); /* decrement reference count */
 	ssl->ctx = ctx;
