untrusted comment: signature from openbsd 5.9 base secret key
RWQJVNompF3pwRbg7my75JmCFypA+bkVSLDFPdwbesk7Fk4bjpj5VOchT2Yli02toK2qsIBLl7GfRkVA6Ile6rMkIHhvgMUNBgU=

OpenBSD 5.9 errata 34, Jan 31, 2017

A bug in the processing of range headers in httpd can lead to memory
exhaustion. This patch disables range header processing.

Apply by doing:
    signify -Vep /etc/signify/openbsd-59-base.pub -x 034_httpd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install httpd:
    cd /usr/src/usr.sbin/httpd
    make obj
    make depend
    make
    make install

Index: usr.sbin/httpd/server_file.c
===================================================================
RCS file: /cvs/src/usr.sbin/httpd/server_file.c,v
retrieving revision 1.60
diff -u -p -u -r1.60 server_file.c
--- usr.sbin/httpd/server_file.c	3 Aug 2015 11:45:17 -0000	1.60
+++ usr.sbin/httpd/server_file.c	31 Jan 2017 15:06:54 -0000
@@ -65,7 +65,6 @@ server_file_access(struct httpd *env, st
 	struct http_descriptor	*desc = clt->clt_descreq;
 	struct server_config	*srv_conf = clt->clt_srv_conf;
 	struct stat		 st;
-	struct kv		*r, key;
 	char			*newpath, *encodedpath;
 	int			 ret;
 
@@ -145,13 +144,7 @@ server_file_access(struct httpd *env, st
 		goto fail;
 	}
 
-	key.kv_key = "Range";
-	r = kv_find(&desc->http_headers, &key);
-	if (r != NULL)
-		return (server_partial_file_request(env, clt, path, &st,
-		    r->kv_value));
-	else
-		return (server_file_request(env, clt, path, &st));
+	return (server_file_request(env, clt, path, &st));
 
  fail:
 	switch (errno) {
