untrusted comment: signature from openbsd 5.9 base secret key
RWQJVNompF3pwedbUIe2RQ9LN7PYIgJkQFXK1DQxLDNU8ZK2j9tDrD8+dVmDJiN3XZe4tyJiPHPnp9gXhRNzqpBHWfOFNBuxLQo=

OpenBSD 5.9 errata 31, Oct 13, 2016:

A logic issue in smtpd's header parsing can cause SMTP sessions to hang.

Apply by doing:
    signify -Vep /etc/signify/openbsd-59-base.pub -x 031_smtpd.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install smtpd:
    cd /usr/src/usr.sbin/smtpd
    make obj
    make depend
    make
    make install

Index: usr.sbin/smtpd/rfc2822.c
===================================================================
RCS file: /cvs/src/usr.sbin/smtpd/rfc2822.c,v
retrieving revision 1.7
diff -u -p -r1.7 rfc2822.c
--- usr.sbin/smtpd/rfc2822.c	4 Feb 2016 22:35:17 -0000	1.7
+++ usr.sbin/smtpd/rfc2822.c	12 Oct 2016 16:03:40 -0000
@@ -50,6 +50,9 @@ header_callback(struct rfc2822_parser *r
 	struct rfc2822_hdr_cb		*hdr_cb;
 	struct rfc2822_hdr_miss_cb	*hdr_miss_cb;
 
+	if (!rp->in_hdr)
+		goto end;
+
 	TAILQ_FOREACH(hdr_cb, &rp->hdr_cb, next)
 	    if (strcasecmp(hdr_cb->name, rp->header.name) == 0) {
 		    hdr_cb->func(&rp->header, hdr_cb->arg);
@@ -147,6 +150,8 @@ rfc2822_parser_flush(struct rfc2822_pars
 		return;
 
 	header_callback(rp);
+
+	missing_headers_callback(rp);
 }
 
 void
Index: usr.sbin/smtpd/smtp_session.c
===================================================================
RCS file: /cvs/src/usr.sbin/smtpd/smtp_session.c,v
retrieving revision 1.268.2.1
diff -u -p -r1.268.2.1 smtp_session.c
--- usr.sbin/smtpd/smtp_session.c	16 May 2016 19:29:13 -0000	1.268.2.1
+++ usr.sbin/smtpd/smtp_session.c	12 Oct 2016 16:03:40 -0000
@@ -1343,6 +1343,8 @@ smtp_io(struct io *io, int evt)
 			s->dataeom = 1;
 			if (iobuf_queued(&s->obuf) == 0)
 				smtp_data_io_done(s);
+			else
+				io_reload(&s->oev);
 			return;
 		}
 
