/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.https;

import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.exceptions.ParserException;
import de.rub.nds.tlsattacker.core.https.HttpsRequestMessage;
import de.rub.nds.tlsattacker.core.https.header.HttpsHeader;
import de.rub.nds.tlsattacker.core.https.header.parser.HttpsHeaderParser;
import de.rub.nds.tlsattacker.core.protocol.parser.ProtocolMessageParser;
import java.nio.charset.Charset;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpsRequestParser
extends ProtocolMessageParser<HttpsRequestMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public HttpsRequestParser(int pointer, byte[] array, ProtocolVersion version, Config config) {
        super(pointer, array, version, config);
    }

    @Override
    protected HttpsRequestMessage parseMessageContent() {
        HttpsRequestMessage message = new HttpsRequestMessage();
        String request = this.parseStringTill((byte)10).trim();
        String[] split = request.replaceAll("\r", " ").split(" ");
        if (split.length != 3) {
            throw new ParserException("Could not parse as HttpsRequestMessage");
        }
        message.setRequestType(split[0]);
        message.setRequestPath(split[1]);
        message.setRequestProtocol(split[2]);
        String line = this.parseStringTill((byte)10);
        while (!line.trim().isEmpty()) {
            HttpsHeaderParser parser = new HttpsHeaderParser(0, line.getBytes(Charset.forName("ASCII")));
            HttpsHeader header = parser.parse();
            message.getHeader().add(header);
            line = this.parseStringTill((byte)10);
        }
        LOGGER.info(new String(this.getAlreadyParsed(), Charset.forName("ASCII")));
        return message;
    }
}

