/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.js;

import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.inline.completion.suggestion.InlineCompletionQuoteHandlerEx;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\f\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J*\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J$\u0010\u0011\u001a\u00020\u000b*\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/inline/completion/js/JSInlineCompletionQuoteHandlerEx;", "Lcom/intellij/codeInsight/inline/completion/suggestion/InlineCompletionQuoteHandlerEx;", "<init>", "()V", "getOpeningQuoteRange", "Lcom/intellij/openapi/util/TextRange;", "documentText", "", "iterator", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "offset", "", "quoteHandler", "Lcom/intellij/codeInsight/editorActions/QuoteHandler;", "getClosingQuoteRange", "isBackquoteOpening", "", "indexOfLast", "startOffset", "endOffset", "char", "", "intellij.fullLine.js"})
public final class JSInlineCompletionQuoteHandlerEx
implements InlineCompletionQuoteHandlerEx {
    @Nullable
    public TextRange getOpeningQuoteRange(@NotNull String documentText, @NotNull HighlighterIterator iterator, int offset, @NotNull QuoteHandler quoteHandler) {
        Intrinsics.checkNotNullParameter((Object)documentText, (String)"documentText");
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        Intrinsics.checkNotNullParameter((Object)quoteHandler, (String)"quoteHandler");
        if (iterator.atEnd()) {
            return null;
        }
        IElementType iElementType = iterator.getTokenType();
        return Intrinsics.areEqual((Object)iElementType, (Object)JSTokenTypes.STRING_TEMPLATE_PART) ? null : (Intrinsics.areEqual((Object)iElementType, (Object)JSTokenTypes.BACKQUOTE) ? (offset == iterator.getStart() && this.isBackquoteOpening(iterator, quoteHandler) ? new TextRange(iterator.getStart(), iterator.getEnd()) : null) : (Intrinsics.areEqual((Object)iElementType, (Object)JSTokenTypes.REGEXP_LITERAL) ? (offset == iterator.getStart() ? new TextRange(offset, offset + 1) : null) : super.getOpeningQuoteRange(documentText, iterator, offset, quoteHandler)));
    }

    @Nullable
    public TextRange getClosingQuoteRange(@NotNull String documentText, @NotNull HighlighterIterator iterator, int offset, @NotNull QuoteHandler quoteHandler) {
        int indexOfSlash;
        Intrinsics.checkNotNullParameter((Object)documentText, (String)"documentText");
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        Intrinsics.checkNotNullParameter((Object)quoteHandler, (String)"quoteHandler");
        if (iterator.atEnd()) {
            return null;
        }
        IElementType iElementType = iterator.getTokenType();
        Object object = Intrinsics.areEqual((Object)iElementType, (Object)JSTokenTypes.STRING_TEMPLATE_PART) ? null : (Intrinsics.areEqual((Object)iElementType, (Object)JSTokenTypes.BACKQUOTE) ? (offset == iterator.getStart() && !this.isBackquoteOpening(iterator, quoteHandler) ? new TextRange(iterator.getStart(), iterator.getEnd()) : null) : (Intrinsics.areEqual((Object)iElementType, (Object)JSTokenTypes.REGEXP_LITERAL) ? (documentText.charAt(offset) == '/' && offset > iterator.getStart() ? (offset == (indexOfSlash = this.indexOfLast(documentText, iterator.getStart(), iterator.getEnd(), '/')) ? new TextRange(offset, offset + 1) : null) : null) : super.getClosingQuoteRange(documentText, iterator, offset, quoteHandler)));
        return object;
    }

    private final boolean isBackquoteOpening(HighlighterIterator iterator, QuoteHandler quoteHandler) {
        iterator.advance();
        boolean success = !iterator.atEnd() && (quoteHandler.isInsideLiteral(iterator) || Intrinsics.areEqual((Object)iterator.getTokenType(), (Object)JSTokenTypes.DOLLAR));
        iterator.retreat();
        return success;
    }

    private final int indexOfLast(String $this$indexOfLast, int startOffset, int endOffset, char c) {
        int i = endOffset - 1;
        if (startOffset <= i) {
            while (true) {
                if ($this$indexOfLast.charAt(i) == c) {
                    return i;
                }
                if (i == startOffset) break;
                --i;
            }
        }
        return -1;
    }
}

