/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.google.common.collect.Sets;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonUiService;
import com.jetbrains.python.codeInsight.intentions.DeclarationConflictChecker;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStarImportElement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImportFromToImportIntention
extends PyBaseIntentionAction {
    @Nullable
    private static PsiElement getElementFromEditor(Editor editor2, PsiFile file) {
        Project project;
        PsiElement element = null;
        Document doc = editor2.getDocument();
        PsiFile a_file = file;
        if (a_file == null && (project = editor2.getProject()) != null) {
            a_file = PsiDocumentManager.getInstance((Project)project).getPsiFile(doc);
        }
        if (a_file != null) {
            element = a_file.findElementAt(editor2.getCaretModel().getOffset());
        }
        return element;
    }

    private static String @Nullable [] getRelativeNames(boolean strict, InfoHolder info) {
        String remaining_name = "?";
        String separated_name = "?";
        boolean failure = true;
        if (info.myModuleReference != null) {
            PyExpression remaining_module = info.myModuleReference.getQualifier();
            remaining_name = remaining_module instanceof PyQualifiedExpression ? PyPsiUtils.toPath((PyQualifiedExpression)remaining_module) : "";
            separated_name = info.myModuleReference.getReferencedName();
            failure = false;
            if (separated_name == null) {
                separated_name = "?";
                failure = true;
            }
        }
        if (strict && failure) {
            return null;
        }
        return new String[]{ImportFromToImportIntention.getDots(info.myRelativeLevel) + remaining_name, separated_name};
    }

    private static String getDots(int level) {
        Object dots = "";
        for (int i = 0; i < level; ++i) {
            dots = (String)dots + ".";
        }
        return dots;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("INTN.NAME.convert.import.qualify", new Object[0]);
        if (string == null) {
            ImportFromToImportIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile psiFile) {
        if (project == null) {
            ImportFromToImportIntention.$$$reportNull$$$0(1);
        }
        if (!(psiFile instanceof PyFile)) {
            return false;
        }
        InfoHolder info = InfoHolder.collect(ImportFromToImportIntention.getElementFromEditor(editor2, psiFile));
        info.myModuleReference = null;
        PsiElement position = psiFile.findElementAt(editor2.getCaretModel().getOffset());
        info.myFromImportStatement = (PyFromImportStatement)PsiTreeUtil.getParentOfType((PsiElement)position, PyFromImportStatement.class);
        PyPsiUtils.assertValid((PsiElement)info.myFromImportStatement);
        if (info.myFromImportStatement != null && !info.myFromImportStatement.isFromFuture()) {
            info.myRelativeLevel = info.myFromImportStatement.getRelativeLevel();
            info.myModuleReference = info.myFromImportStatement.getImportSource();
            if (info.myRelativeLevel > 0) {
                for (PyImportElement import_element : info.myFromImportStatement.getImportElements()) {
                    PyReferenceExpression ref = import_element.getImportReferenceExpression();
                    PyPsiUtils.assertValid((PsiElement)ref);
                    if (ref == null) continue;
                    PsiElement target = ref.getReference().resolve();
                    TypeEvalContext context = TypeEvalContext.codeAnalysis(psiFile.getProject(), psiFile);
                    if (!(target instanceof PyExpression) || !(context.getType((PyExpression)target) instanceof PyModuleType)) continue;
                    return false;
                }
            }
        }
        if (info.myModuleReference != null) {
            info.myModuleName = PyPsiUtils.toPath(info.myModuleReference);
        }
        if (info.myModuleReference != null && info.myFromImportStatement != null) {
            this.setText(info.getText());
            return true;
        }
        return false;
    }

    private static void qualifyTarget(ASTNode target_node, Project project, String qualifier) {
        PyElementGenerator generator = PyElementGenerator.getInstance(project);
        target_node.addChild(generator.createDot(), target_node.getFirstChildNode());
        target_node.addChild(PyUtil.sure(((PyReferenceExpression)generator.createFromText(LanguageLevel.getDefault(), PyReferenceExpression.class, qualifier, new int[]{0, 0})).getNode()), target_node.getFirstChildNode());
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            ImportFromToImportIntention.$$$reportNull$$$0(2);
        }
        InfoHolder info = InfoHolder.collect(ImportFromToImportIntention.getElementFromEditor(editor2, file));
        try {
            ASTNode target_node;
            PsiElement referring_elt;
            PyQualifiedExpression top_qualifier;
            String qualifier;
            PyUtil.sure(info.myModuleReference);
            PyUtil.sure(info.myModuleName);
            String[] relative_names = null;
            if (info.myRelativeLevel > 0) {
                relative_names = ImportFromToImportIntention.getRelativeNames(true, info);
                if (relative_names == null) {
                    throw new IncorrectOperationException("failed to get relative names");
                }
                qualifier = relative_names[1];
            } else {
                qualifier = info.myModuleName;
            }
            final PyImportElement[] ielts = info.myFromImportStatement.getImportElements();
            final PyStarImportElement star_ielt = info.myFromImportStatement.getStarImportElement();
            final HashMap references2 = new HashMap();
            final ArrayList star_references = new ArrayList();
            PsiTreeUtil.processElements((PsiElement)file, (PsiElementProcessor)new PsiElementProcessor(){

                public boolean execute(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    PyPsiUtils.assertValid(element);
                    if (element instanceof PyReferenceExpression) {
                        PyReferenceExpression ref = (PyReferenceExpression)element;
                        if (PsiTreeUtil.getParentOfType((PsiElement)element, PyImportElement.class) == null && !ref.isQualified()) {
                            ResolveResult[] resolved;
                            for (ResolveResult rr : resolved = ref.getReference().multiResolve(false)) {
                                if (!rr.isValidResult()) continue;
                                if (rr.getElement() == star_ielt) {
                                    star_references.add(ref.getReference());
                                }
                                for (PyImportElement ielt : ielts) {
                                    if (rr.getElement() != ielt) continue;
                                    references2.put(ref.getReference(), ielt);
                                }
                            }
                        }
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/intentions/ImportFromToImportIntention$1", "execute"));
                }
            });
            PyExpression feeler = info.myModuleReference;
            do {
                PyUtil.sure(feeler instanceof PyQualifiedExpression);
            } while ((feeler = (top_qualifier = (PyQualifiedExpression)feeler).getQualifier()) != null);
            String top_name = top_qualifier.getName();
            Collection<Object> possible_targets = references2.keySet();
            if (!star_references.isEmpty()) {
                possible_targets = new ArrayList(references2.size() + star_references.size());
                possible_targets.addAll(references2.keySet());
                possible_targets.addAll(star_references);
            }
            HashSet ignored = Sets.newHashSet(Arrays.asList(info.myFromImportStatement.getImportElements()));
            if (top_name != null && PythonUiService.getInstance().showConflicts(project, DeclarationConflictChecker.findDefinitions(top_name, possible_targets, ignored), top_name, info.myModuleName)) {
                return;
            }
            PyElementGenerator generator = PyElementGenerator.getInstance(project);
            LanguageLevel level = LanguageLevel.forElement((PsiElement)file);
            for (Map.Entry entry : references2.entrySet()) {
                referring_elt = ((PsiReference)entry.getKey()).getElement();
                assert (referring_elt.isValid());
                target_node = referring_elt.getNode();
                assert (target_node != null);
                PyImportElement ielt = (PyImportElement)entry.getValue();
                if (ielt.getAsNameElement() != null) {
                    PyReferenceExpression refex = ielt.getImportReferenceExpression();
                    assert (refex != null);
                    String real_name = refex.getReferencedName();
                    ASTNode new_qualifier = generator.createExpressionFromText(level, real_name).getNode();
                    assert (new_qualifier != null);
                    target_node.getTreeParent().replaceChild(target_node, new_qualifier);
                    target_node = new_qualifier;
                }
                ImportFromToImportIntention.qualifyTarget(target_node, project, qualifier);
            }
            for (PsiReference reference : star_references) {
                referring_elt = reference.getElement();
                assert (referring_elt.isValid());
                target_node = referring_elt.getNode();
                assert (target_node != null);
                ImportFromToImportIntention.qualifyTarget(target_node, project, qualifier);
            }
            PyStatement new_import = info.myRelativeLevel == 0 ? (PyStatement)PyUtil.sure((PyImportStatement)generator.createFromText(level, PyImportStatement.class, "import " + info.myModuleName)) : (PyStatement)PyUtil.sure((PyFromImportStatement)generator.createFromText(level, PyFromImportStatement.class, "from " + relative_names[0] + " import " + relative_names[1]));
            ASTNode parent = PyUtil.sure(info.myFromImportStatement.getParent().getNode());
            ASTNode old_node = PyUtil.sure(info.myFromImportStatement.getNode());
            parent.replaceChild(old_node, PyUtil.sure(new_import.getNode()));
        }
        catch (IncorrectOperationException ignored) {
            PythonUiService.getInstance().showBalloonError(project, PyPsiBundle.message("QFIX.action.failed", new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/ImportFromToImportIntention";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/ImportFromToImportIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static class InfoHolder {
        PyFromImportStatement myFromImportStatement = null;
        PyReferenceExpression myModuleReference = null;
        String myModuleName = null;
        int myRelativeLevel = 0;

        private InfoHolder() {
        }

        @NotNull
        @IntentionName
        public String getText() {
            String name2;
            String string = name2 = this.myModuleName != null ? this.myModuleName : "...";
            if (this.myRelativeLevel > 0) {
                String[] relative_names = ImportFromToImportIntention.getRelativeNames(false, this);
                String string2 = PyPsiBundle.message("INTN.convert.to.from.import", relative_names[0], relative_names[1]);
                if (string2 == null) {
                    InfoHolder.$$$reportNull$$$0(0);
                }
                return string2;
            }
            String string3 = PyPsiBundle.message("INTN.convert.to.plain.import", name2);
            if (string3 == null) {
                InfoHolder.$$$reportNull$$$0(1);
            }
            return string3;
        }

        public static InfoHolder collect(PsiElement position) {
            InfoHolder ret = new InfoHolder();
            ret.myModuleReference = null;
            ret.myFromImportStatement = (PyFromImportStatement)PsiTreeUtil.getParentOfType((PsiElement)position, PyFromImportStatement.class);
            PyPsiUtils.assertValid((PsiElement)ret.myFromImportStatement);
            if (ret.myFromImportStatement != null && !ret.myFromImportStatement.isFromFuture()) {
                ret.myRelativeLevel = ret.myFromImportStatement.getRelativeLevel();
                ret.myModuleReference = ret.myFromImportStatement.getImportSource();
            }
            if (ret.myModuleReference != null) {
                ret.myModuleName = PyPsiUtils.toPath(ret.myModuleReference);
            }
            return ret;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/intentions/ImportFromToImportIntention$InfoHolder", "getText"));
        }
    }
}

