/*
 * Decompiled with CFR 0.152.
 */
package tr.view.future.filters;

import ca.odell.glazedlists.matchers.Matcher;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import org.openide.util.NbBundle;
import tr.model.future.Future;
import tr.view.filters.FilterComboAbstract;
import tr.view.future.filters.MatcherEditorBase;

public class MatcherEditorSearch
extends MatcherEditorBase
implements PropertyChangeListener {
    private final SearchComboBox searchCombo = new SearchComboBox();

    public MatcherEditorSearch() {
        this.searchCombo.addValueChangeListener(this);
    }

    public Component getComponent() {
        return this.searchCombo;
    }

    public void propertyChange(PropertyChangeEvent e) {
        String string = (String)this.searchCombo.getSelectedItem();
        if (string == null || string.trim().length() == 0) {
            this.fireMatchAll();
        } else {
            this.fireChanged(new SearchMatcher(string));
        }
    }

    public String getLabel() {
        return NbBundle.getMessage(this.getClass(), (String)"filter-search");
    }

    public Serializable getSerializable() {
        return (Serializable)this.searchCombo.getSelectedItem();
    }

    public void setSerializable(Serializable serializable) {
        this.searchCombo.setSelectedItem(serializable);
    }

    private class SearchComboBox
    extends FilterComboAbstract {
        private ActionListener listener;
        public String string;

        public SearchComboBox() {
            super((ComboBoxModel)new SearchComboBoxModel());
            this.listener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String string;
                    SearchComboBox.this.setString(null);
                    Object object = SearchComboBox.this.getSelectedItem();
                    if (object instanceof String && (string = ((String)object).trim()).length() > 0) {
                        SearchComboBox.this.setString(string);
                    }
                }
            };
            this.setEditable(true);
            this.addActionListener(this.listener);
        }

        public void stopChangeEvents() {
            this.removeActionListener(this.listener);
        }

        public void startChangeEvents() {
            this.addActionListener(this.listener);
        }

        private void setString(String string) {
            if (string == null || string.trim().length() == 0) {
                this.string = null;
            } else {
                this.string = string.trim().toLowerCase();
                SearchComboBoxModel model = (SearchComboBoxModel)this.getModel();
                model.addSearch(string);
            }
            this.fireValueChange();
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComboBox dummy = new JComboBox();
            dummy.setEnabled(true);
            dummy.setBackground(Color.white);
            return dummy;
        }
    }

    private class SearchComboBoxModel
    extends DefaultComboBoxModel {
        public final Vector<String> searches = new Vector();

        private SearchComboBoxModel() {
        }

        public void addSearch(String search) {
            if (search == null) {
                return;
            }
            if ((search = search.trim()).length() > 0 && !this.searches.contains(search)) {
                this.searches.add(search);
                this.fireContentsChanged(search, 0, this.searches.size());
            }
        }

        public Object getElementAt(int index) {
            return this.searches.get(index);
        }

        public int getSize() {
            return this.searches.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SearchMatcher
    implements Matcher<Future> {
        private final String search;

        public SearchMatcher() {
            this.search = null;
        }

        public SearchMatcher(String search) {
            this.search = search.toLowerCase();
        }

        public boolean matches(Future future) {
            if (future.getDescription().toLowerCase().contains(this.search)) {
                return true;
            }
            return future.getNotes().toLowerCase().contains(this.search);
        }
    }
}

