/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * equal(vec2(-1.5, -1.5), vec2(-1.5, -0.5)) => bvec2(true, false)
 * equal(vec2(-1.5, -1.5), vec2(0.5, 1.5)) => bvec2(false, false)
 * equal(vec2(-0.5, -0.5), vec2(-1.5, -0.5)) => bvec2(false, true)
 * equal(vec2(-0.5, -0.5), vec2(0.5, 1.5)) => bvec2(false, false)
 * equal(vec2(0.5, 0.5), vec2(-1.5, -0.5)) => bvec2(false, false)
 * equal(vec2(0.5, 0.5), vec2(0.5, 1.5)) => bvec2(true, false)
 * equal(vec2(1.5, 1.5), vec2(-1.5, -0.5)) => bvec2(false, false)
 * equal(vec2(1.5, 1.5), vec2(0.5, 1.5)) => bvec2(false, true)
 */
#version 120

void main()
{
  float[equal(vec2(-1.5, -1.5), vec2(-1.5, -0.5))[0] == true && equal(vec2(-1.5, -1.5), vec2(-1.5, -0.5))[1] == false ? 1 : -1] array0;
  float[equal(vec2(-1.5, -1.5), vec2(0.5, 1.5))[0] == false && equal(vec2(-1.5, -1.5), vec2(0.5, 1.5))[1] == false ? 1 : -1] array1;
  float[equal(vec2(-0.5, -0.5), vec2(-1.5, -0.5))[0] == false && equal(vec2(-0.5, -0.5), vec2(-1.5, -0.5))[1] == true ? 1 : -1] array2;
  float[equal(vec2(-0.5, -0.5), vec2(0.5, 1.5))[0] == false && equal(vec2(-0.5, -0.5), vec2(0.5, 1.5))[1] == false ? 1 : -1] array3;
  float[equal(vec2(0.5, 0.5), vec2(-1.5, -0.5))[0] == false && equal(vec2(0.5, 0.5), vec2(-1.5, -0.5))[1] == false ? 1 : -1] array4;
  float[equal(vec2(0.5, 0.5), vec2(0.5, 1.5))[0] == true && equal(vec2(0.5, 0.5), vec2(0.5, 1.5))[1] == false ? 1 : -1] array5;
  float[equal(vec2(1.5, 1.5), vec2(-1.5, -0.5))[0] == false && equal(vec2(1.5, 1.5), vec2(-1.5, -0.5))[1] == false ? 1 : -1] array6;
  float[equal(vec2(1.5, 1.5), vec2(0.5, 1.5))[0] == false && equal(vec2(1.5, 1.5), vec2(0.5, 1.5))[1] == true ? 1 : -1] array7;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
