/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class GenericMap
implements Map {
    protected int size;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    protected int keyHash(Object key2) {
        return key2 == null ? 0 : key2.hashCode();
    }

    protected boolean keyEquals(Object containedKey, Object givenKey) {
        return containedKey == null ? givenKey == null : containedKey.equals(givenKey);
    }

    protected int valueHash(Object value2) {
        return value2 == null ? 0 : value2.hashCode();
    }

    protected boolean valueEquals(Object value1, Object value2) {
        return value1 == null ? value2 == null : value1.equals(value2);
    }

    public void putAll(Map other) {
        if (other == this) {
            return;
        }
        for (Map.Entry entry : other.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    protected abstract Iterator entryIterator();

    protected Iterator keyIterator() {
        return new KeyIterator(this);
    }

    protected Iterator valueIterator() {
        return new ValueIterator(this);
    }

    private static Object[] toArray(Object[] arr, int size2, Iterator it) {
        Object[] out = arr != null && arr.length >= size2 ? arr : (arr == null ? new Object[size2] : (Object[])Array.newInstance(arr.getClass().getComponentType(), size2));
        for (int i2 = 0; i2 < size2; ++i2) {
            out[i2] = it.next();
        }
        if (out.length > size2) {
            out[size2] = null;
        }
        return out;
    }

    public Collection values() {
        return new AbstractCollection(){

            @Override
            public Iterator iterator() {
                return GenericMap.this.valueIterator();
            }

            @Override
            public int size() {
                return GenericMap.this.size();
            }

            @Override
            public Object[] toArray(Object[] arr) {
                return GenericMap.toArray(arr, this.size(), this.iterator());
            }
        };
    }

    public Set keySet() {
        return new AbstractSet(){

            @Override
            public Iterator iterator() {
                return GenericMap.this.keyIterator();
            }

            @Override
            public int size() {
                return GenericMap.this.size();
            }

            @Override
            public Object[] toArray(Object[] arr) {
                return GenericMap.toArray(arr, this.size(), this.iterator());
            }
        };
    }

    @Override
    public int hashCode() {
        int code = 0;
        Iterator it = this.entryIterator();
        while (it.hasNext()) {
            code += it.next().hashCode();
        }
        return code;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Map)) {
            return false;
        }
        Map map2 = (Map)other;
        if (map2.size() != this.size()) {
            return false;
        }
        Iterator it = this.entryIterator();
        while (it.hasNext()) {
            Object otherVal;
            Entry ent = (Entry)it.next();
            Object key2 = ent.getKey();
            Object val = ent.getValue();
            if (!map2.containsKey(key2) || this.valueEquals(val, otherVal = map2.get(key2))) continue;
            return false;
        }
        return true;
    }

    public Set entrySet() {
        return new AbstractSet(){

            @Override
            public Iterator iterator() {
                return GenericMap.this.entryIterator();
            }

            @Override
            public int size() {
                return GenericMap.this.size;
            }

            @Override
            public Object[] toArray(Object[] arr) {
                return GenericMap.toArray(arr, this.size(), this.iterator());
            }
        };
    }

    @Override
    public boolean containsValue(Object value2) {
        Iterator it = this.valueIterator();
        while (it.hasNext()) {
            if (!this.valueEquals(value2, it.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.get(key2) != null;
    }

    class KeyIterator
    extends KeyOrValueIterator {
        KeyIterator(GenericMap this$0) {
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    class ValueIterator
    extends KeyOrValueIterator {
        ValueIterator(GenericMap this$0) {
        }

        public Object next() {
            return this.nextEntry().getValue();
        }
    }

    abstract class Entry
    implements Map.Entry {
        Entry() {
        }

        @Override
        public int hashCode() {
            return GenericMap.this.keyHash(this.getKey()) ^ GenericMap.this.valueHash(this.getValue());
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof Map.Entry) {
                Map.Entry ent = (Map.Entry)other;
                return GenericMap.this.keyEquals(this.getKey(), ent.getKey()) && GenericMap.this.valueEquals(this.getValue(), ent.getValue());
            }
            return false;
        }
    }

    abstract class KeyOrValueIterator
    implements Iterator {
        final Iterator iter;

        KeyOrValueIterator() {
            this.iter = GenericMap.this.entryIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        protected Map.Entry nextEntry() {
            return (Map.Entry)this.iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

