/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.srtp.crypto;

import java.lang.ref.Cleaner;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.AEADBadTagException;
import javax.crypto.CipherSpi;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import org.jitsi.srtp.crypto.JitsiOpenSslProvider;

public class OpenSslAesGcmAuthOnlyCipherSpi
extends CipherSpi
implements AutoCloseable {
    private static final int BLKLEN = 16;
    private Key key;
    private final OpenSslAesGcmAuthOnlyCipherSpiCleanable ctx;
    private final Cleaner.Cleanable ctxCleanable;
    private byte[] iv;
    private int tagLen;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    private static native long CRYPTO_gcm128_new();

    private static native void CRYPTO_gcm128_release(long var0);

    private native boolean CRYPTO_gcm128_init(long var1, byte[] var3);

    private native boolean CRYPTO_gcm128_setiv(long var1, byte[] var3, int var4);

    private native boolean CRYPTO_gcm128_aad(long var1, byte[] var3, int var4, int var5);

    private native boolean CRYPTO_gcm128_decrypt(long var1, byte[] var3, int var4, int var5);

    private native boolean CRYPTO_gcm128_finish(long var1, byte[] var3, int var4, int var5);

    public OpenSslAesGcmAuthOnlyCipherSpi() {
        if (!JitsiOpenSslProvider.isLoaded()) {
            throw new RuntimeException("OpenSSL wrapper not loaded");
        }
        this.ctx = new OpenSslAesGcmAuthOnlyCipherSpiCleanable();
        this.ctx.ptr = OpenSslAesGcmAuthOnlyCipherSpi.CRYPTO_gcm128_new();
        if (this.ctx.ptr == 0L) {
            throw new IllegalStateException("Error constructing ctx");
        }
        this.ctxCleanable = JitsiOpenSslProvider.CLEANER.register(this, this.ctx);
    }

    @Override
    public void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (!"gcm-authonly".equalsIgnoreCase(mode)) {
            throw new NoSuchAlgorithmException("Unsupported mode " + mode);
        }
    }

    @Override
    public void engineSetPadding(String padding) throws NoSuchPaddingException {
        if (!"nopadding".equalsIgnoreCase(padding)) {
            throw new NoSuchPaddingException("No padding support");
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return 16;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return 0;
    }

    @Override
    protected byte[] engineGetIV() {
        return Arrays.copyOf(this.iv, this.iv.length);
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException("could not create params", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!key.getAlgorithm().equalsIgnoreCase("AES") || !key.getFormat().equalsIgnoreCase("RAW") || key.getEncoded().length != 16 && key.getEncoded().length != 24 && key.getEncoded().length != 32) {
            throw new InvalidKeyException("AES SecretKeySpec expected, got " + key.getEncoded().length + " " + key.getAlgorithm() + "/" + key.getFormat());
        }
        if (opmode != 2) {
            throw new InvalidAlgorithmParameterException("Unsupported opmode " + opmode);
        }
        if (params == null) throw new InvalidAlgorithmParameterException("IV parameter missing");
        if (!(params instanceof GCMParameterSpec)) throw new InvalidAlgorithmParameterException("Unsupported parameter: " + params);
        if (((GCMParameterSpec)params).getTLen() != 128) {
            throw new InvalidAlgorithmParameterException("Unsupported GCM tag length: must be 128");
        }
        this.tagLen = ((GCMParameterSpec)params).getTLen() / 8;
        this.iv = ((GCMParameterSpec)params).getIV();
        byte[] keyParam = null;
        if (key != this.key) {
            this.key = key;
            keyParam = key.getEncoded();
        }
        if (keyParam != null && !this.CRYPTO_gcm128_init(this.ctx.ptr, keyParam)) {
            throw new InvalidKeyException("CRYPTO_gcm128_init");
        }
        if (this.iv == null || this.CRYPTO_gcm128_setiv(this.ctx.ptr, this.iv, this.iv.length)) return;
        throw new InvalidAlgorithmParameterException("CRYPTO_gcm128_setiv");
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        GCMParameterSpec spec = null;
        if (params != null) {
            try {
                spec = params.getParameterSpec(GCMParameterSpec.class);
            }
            catch (InvalidParameterSpecException e) {
                throw new InvalidAlgorithmParameterException(e);
            }
        }
        this.engineInit(opmode, key, spec, random);
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        this.engineUpdate(input, inputOffset, inputLen, null, 0);
        return EMPTY_BYTE_ARRAY;
    }

    private void doDecrypt(byte[] input, int inputOffset, int inputLen) {
        if (!this.CRYPTO_gcm128_decrypt(this.ctx.ptr, input, inputOffset, inputLen)) {
            throw new IllegalStateException("Failure in CRYPTO_gcm128_decrypt");
        }
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        throw new UnsupportedOperationException("Update not supported for GCM Decryption");
    }

    @Override
    protected void engineUpdateAAD(byte[] input, int inputOffset, int inputLen) {
        if (inputOffset + inputLen > input.length) {
            throw new IllegalArgumentException("Input buffer length " + input.length + " is too short for offset " + inputOffset + " plus length " + inputLen);
        }
        if (!this.CRYPTO_gcm128_aad(this.ctx.ptr, input, inputOffset, inputLen)) {
            throw new IllegalStateException("Failure in CRYPTO_gcm128_aad");
        }
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws AEADBadTagException {
        this.engineDoFinal(input, inputOffset, inputLen, null, 0);
        return EMPTY_BYTE_ARRAY;
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws AEADBadTagException {
        if (inputOffset + inputLen > input.length) {
            throw new IllegalArgumentException("Input buffer length " + input.length + " is too short for offset " + inputOffset + " plus length " + inputLen);
        }
        if (inputLen < this.tagLen) {
            throw new AEADBadTagException("Input too short - need tag");
        }
        int ciphertextLen = inputLen - this.tagLen;
        this.doDecrypt(input, inputOffset, ciphertextLen);
        int tagOffset = inputOffset + ciphertextLen;
        if (!this.CRYPTO_gcm128_finish(this.ctx.ptr, input, tagOffset, this.tagLen)) {
            throw new AEADBadTagException("Bad AEAD tag");
        }
        return ciphertextLen;
    }

    @Override
    public void close() {
        this.ctxCleanable.clean();
    }

    private static final class OpenSslAesGcmAuthOnlyCipherSpiCleanable
    implements Runnable {
        long ptr;

        private OpenSslAesGcmAuthOnlyCipherSpiCleanable() {
        }

        @Override
        public void run() {
            if (this.ptr != 0L) {
                OpenSslAesGcmAuthOnlyCipherSpi.CRYPTO_gcm128_release(this.ptr);
                this.ptr = 0L;
            }
        }
    }
}

