/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Arrays;

public class NcrEscapingWindows1252OutputStreamWriter
extends Writer {
    private static final int SURROGATE_OFFSET = -56613888;
    private static int[] CODE_POINTS = new int[]{338, 339, 352, 353, 376, 381, 382, 402, 710, 732, 8211, 8212, 8216, 8217, 8218, 8220, 8221, 8222, 8224, 8225, 8226, 8230, 8240, 8249, 8250, 8364, 8482};
    private static int[] BYTES = new int[]{140, 156, 138, 154, 159, 142, 158, 131, 136, 152, 150, 151, 145, 146, 130, 147, 148, 132, 134, 135, 149, 133, 137, 139, 155, 128, 153};
    private OutputStream out;
    private int prev;

    public NcrEscapingWindows1252OutputStreamWriter(OutputStream out) {
        this.out = out;
        this.prev = 0;
    }

    @Override
    public void write(char[] buf, int offset, int count) throws IOException {
        int end = offset + count;
        for (int i = offset; i < end; ++i) {
            this.write(buf[i]);
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void write(int c) throws IOException {
        int i = -1;
        if ((c &= 0xFFFF) < 128) {
            this.out.write(c);
            this.prev = 0;
            return;
        }
        if (c < 160) {
            this.prev = 0;
            return;
        }
        if (c < 256) {
            this.out.write(c);
            this.prev = 0;
            return;
        }
        i = Arrays.binarySearch(CODE_POINTS, c);
        if (i >= 0) {
            this.out.write(BYTES[i]);
            this.prev = 0;
            return;
        }
        if ((c & 0xFC00) == 56320) {
            if (this.prev != 0) {
                int intVal = (this.prev << 10) + c + -56613888;
                this.prev = 0;
                this.writeNcr(intVal);
                return;
            }
            this.prev = 0;
            return;
        }
        if ((c & 0xFC00) == 55296) {
            this.prev = c;
            return;
        }
        this.writeNcr(c);
        this.prev = 0;
    }

    private void writeNcr(int c) throws IOException {
        this.out.write(38);
        this.out.write(35);
        String str = Integer.toString(c);
        for (int i = 0; i < str.length(); ++i) {
            this.out.write(str.charAt(i));
        }
        this.out.write(59);
    }
}

