/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.backend.split.diff;

import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.editor.DiffRequestProcessorEditorCustomizer;
import com.intellij.diff.editor.DiffViewerVirtualFile;
import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.client.ClientType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.StructureViewFileEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.vcs.backend.split.diff.BackendDiffRequestProcessorEditor;
import com.intellij.platform.vcs.backend.split.diff.BackendServerDiffManagerKt;
import com.intellij.platform.vcs.backend.split.diff.DiffRequestDirectTransferEditor;
import com.intellij.platform.vcs.backend.split.diff.DiffRequestRemoteEditor;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/platform/vcs/backend/split/diff/BackendDiffFileEditorProvider;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "Lcom/intellij/openapi/fileEditor/ex/StructureViewFileEditorProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "acceptRequiresReadAction", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "disposeEditor", "", "editor", "getEditorTypeId", "", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "getStructureViewBuilder", "Lcom/intellij/ide/structureView/StructureViewBuilder;", "intellij.platform.vcs.backend.split"})
final class BackendDiffFileEditorProvider
implements FileEditorProvider,
StructureViewFileEditorProvider,
DumbAware {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof DiffViewerVirtualFile;
    }

    public boolean acceptRequiresReadAction() {
        return false;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        DiffViewerVirtualFile cfr_ignored_0 = (DiffViewerVirtualFile)file;
        ClientProjectSession session = ClientSessionsUtil.getCurrentSession((Project)project);
        switch (WhenMappings.$EnumSwitchMapping$0[session.getType().ordinal()]) {
            case 1: {
                DiffEditorViewer processor = ((DiffViewerVirtualFile)file).createViewer(project);
                BackendDiffRequestProcessorEditor editor = new BackendDiffRequestProcessorEditor((DiffViewerVirtualFile)file, processor);
                DiffRequestProcessorEditorCustomizer.Companion.customize(file, (FileEditor)editor, processor.getContext());
                return (FileEditor)editor;
            }
            case 2: {
                DiffEditorViewer processor = ((DiffViewerVirtualFile)file).createViewer(project);
                return (FileEditor)new DiffRequestDirectTransferEditor(session, (DiffViewerVirtualFile)file, processor);
            }
            case 3: {
                DiffRequestChain diffRequestChain = BackendServerDiffManagerKt.access$extractRequestChain(file);
                if (diffRequestChain == null) {
                    throw new IllegalStateException(("Can't get request chain for " + file).toString());
                }
                DiffRequestChain chain = diffRequestChain;
                return (FileEditor)new DiffRequestRemoteEditor(session, (DiffViewerVirtualFile)file, chain);
            }
            case 4: {
                throw new IllegalStateException("Must not be observed".toString());
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    public void disposeEditor(@NotNull FileEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Disposer.dispose((Disposable)((Disposable)editor));
    }

    @NotNull
    public String getEditorTypeId() {
        return "BackendDiffFileEditorProvider";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClientType.values().length];
            try {
                nArray[ClientType.LOCAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientType.CONTROLLER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientType.GUEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientType.FRONTEND.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

