/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;

final class GrowableByteArrayDataOutput
extends DataOutput
implements Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(GrowableByteArrayDataOutput.class);
    private static final int INITIAL_SIZE = 256;
    private byte[] bytes = new byte[256];
    private int nextWrite;

    GrowableByteArrayDataOutput() {
    }

    @Override
    public void writeByte(byte b) {
        this.ensureCapacity(1);
        this.bytes[this.nextWrite++] = b;
    }

    @Override
    public void writeBytes(byte[] b, int offset, int len) {
        if (len == 0) {
            return;
        }
        this.ensureCapacity(len);
        System.arraycopy(b, offset, this.bytes, this.nextWrite, len);
        this.nextWrite += len;
    }

    public int getPosition() {
        return this.nextWrite;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setPosition(int newLen) {
        assert (newLen >= 0);
        if (newLen > this.nextWrite) {
            this.ensureCapacity(newLen - this.nextWrite);
        }
        this.nextWrite = newLen;
    }

    private void ensureCapacity(int capacityToWrite) {
        assert (capacityToWrite > 0);
        this.bytes = ArrayUtil.grow(this.bytes, this.nextWrite + capacityToWrite);
    }

    public void writeTo(DataOutput out) throws IOException {
        out.writeBytes(this.bytes, 0, this.nextWrite);
    }

    public void writeTo(int srcOffset, byte[] dest, int destOffset, int len) {
        assert (srcOffset + len <= this.nextWrite);
        System.arraycopy(this.bytes, srcOffset, dest, destOffset, len);
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.bytes);
    }
}

