/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.memorycontainer;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.memorycontainer.MemoryStorageConfig;

public class MLCreateMemoryContainerInput
implements ToXContentObject,
Writeable {
    public static final String NAME_FIELD = "name";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String MEMORY_STORAGE_CONFIG_FIELD = "memory_storage_config";
    private String name;
    private String description;
    private MemoryStorageConfig memoryStorageConfig;
    private String tenantId;

    public MLCreateMemoryContainerInput(String name, String description, MemoryStorageConfig memoryStorageConfig, String tenantId) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
        this.description = description;
        this.memoryStorageConfig = memoryStorageConfig;
        this.tenantId = tenantId;
    }

    public MLCreateMemoryContainerInput(StreamInput in) throws IOException {
        this.name = in.readString();
        this.description = in.readOptionalString();
        this.memoryStorageConfig = in.readBoolean() ? new MemoryStorageConfig(in) : null;
        this.tenantId = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeOptionalString(this.description);
        if (this.memoryStorageConfig != null) {
            out.writeBoolean(true);
            this.memoryStorageConfig.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.tenantId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME_FIELD, this.name);
        if (this.description != null) {
            builder.field(DESCRIPTION_FIELD, this.description);
        }
        if (this.memoryStorageConfig != null) {
            builder.field(MEMORY_STORAGE_CONFIG_FIELD, (ToXContent)this.memoryStorageConfig);
        }
        if (this.tenantId != null) {
            builder.field("tenant_id", this.tenantId);
        }
        builder.endObject();
        return builder;
    }

    public static MLCreateMemoryContainerInput parse(XContentParser parser) throws IOException {
        String name = null;
        String description = null;
        MemoryStorageConfig memoryStorageConfig = null;
        String tenantId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block12: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    continue block12;
                }
                case "description": {
                    description = parser.text();
                    continue block12;
                }
                case "memory_storage_config": {
                    memoryStorageConfig = MemoryStorageConfig.parse(parser);
                    continue block12;
                }
                case "tenant_id": {
                    tenantId = parser.text();
                    continue block12;
                }
            }
            parser.skipChildren();
        }
        return MLCreateMemoryContainerInput.builder().name(name).description(description).memoryStorageConfig(memoryStorageConfig).tenantId(tenantId).build();
    }

    @Generated
    public static MLCreateMemoryContainerInputBuilder builder() {
        return new MLCreateMemoryContainerInputBuilder();
    }

    @Generated
    public MLCreateMemoryContainerInputBuilder toBuilder() {
        return new MLCreateMemoryContainerInputBuilder().name(this.name).description(this.description).memoryStorageConfig(this.memoryStorageConfig).tenantId(this.tenantId);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public MemoryStorageConfig getMemoryStorageConfig() {
        return this.memoryStorageConfig;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setMemoryStorageConfig(MemoryStorageConfig memoryStorageConfig) {
        this.memoryStorageConfig = memoryStorageConfig;
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLCreateMemoryContainerInput)) {
            return false;
        }
        MLCreateMemoryContainerInput other = (MLCreateMemoryContainerInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        MemoryStorageConfig this$memoryStorageConfig = this.getMemoryStorageConfig();
        MemoryStorageConfig other$memoryStorageConfig = other.getMemoryStorageConfig();
        if (this$memoryStorageConfig == null ? other$memoryStorageConfig != null : !((Object)this$memoryStorageConfig).equals(other$memoryStorageConfig)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        return !(this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLCreateMemoryContainerInput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        MemoryStorageConfig $memoryStorageConfig = this.getMemoryStorageConfig();
        result = result * 59 + ($memoryStorageConfig == null ? 43 : ((Object)$memoryStorageConfig).hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MLCreateMemoryContainerInput(name=" + this.getName() + ", description=" + this.getDescription() + ", memoryStorageConfig=" + String.valueOf(this.getMemoryStorageConfig()) + ", tenantId=" + this.getTenantId() + ")";
    }

    @Generated
    public static class MLCreateMemoryContainerInputBuilder {
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private MemoryStorageConfig memoryStorageConfig;
        @Generated
        private String tenantId;

        @Generated
        MLCreateMemoryContainerInputBuilder() {
        }

        @Generated
        public MLCreateMemoryContainerInputBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public MLCreateMemoryContainerInputBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public MLCreateMemoryContainerInputBuilder memoryStorageConfig(MemoryStorageConfig memoryStorageConfig) {
            this.memoryStorageConfig = memoryStorageConfig;
            return this;
        }

        @Generated
        public MLCreateMemoryContainerInputBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public MLCreateMemoryContainerInput build() {
            return new MLCreateMemoryContainerInput(this.name, this.description, this.memoryStorageConfig, this.tenantId);
        }

        @Generated
        public String toString() {
            return "MLCreateMemoryContainerInput.MLCreateMemoryContainerInputBuilder(name=" + this.name + ", description=" + this.description + ", memoryStorageConfig=" + String.valueOf(this.memoryStorageConfig) + ", tenantId=" + this.tenantId + ")";
        }
    }
}

