/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.workflow;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.flowframework.common.WorkflowResources;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.exception.WorkflowStepException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.flowframework.workflow.WorkflowStep;
import org.opensearch.ml.client.MachineLearningNodeClient;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.model.Guardrails;
import org.opensearch.ml.common.transport.register.MLRegisterModelInput;
import org.opensearch.ml.common.transport.register.MLRegisterModelResponse;

public class RegisterRemoteModelStep
implements WorkflowStep {
    private static final Logger logger = LogManager.getLogger(RegisterRemoteModelStep.class);
    private final MachineLearningNodeClient mlClient;
    private final FlowFrameworkIndicesHandler flowFrameworkIndicesHandler;
    public static final String NAME = "register_remote_model";

    public RegisterRemoteModelStep(MachineLearningNodeClient mlClient, FlowFrameworkIndicesHandler flowFrameworkIndicesHandler) {
        this.mlClient = mlClient;
        this.flowFrameworkIndicesHandler = flowFrameworkIndicesHandler;
    }

    @Override
    public PlainActionFuture<WorkflowData> execute(final String currentNodeId, final WorkflowData currentNodeInputs, Map<String, WorkflowData> outputs, Map<String, String> previousNodeInputs, Map<String, String> params, final String tenantId) {
        final PlainActionFuture registerRemoteModelFuture = PlainActionFuture.newFuture();
        Set<String> requiredKeys = Set.of("name", "connector_id");
        Set<String> optionalKeys = Set.of("model_group_id", "description", "deploy", "guardrails", "interface");
        try {
            Map<String, Object> inputs = ParseUtils.getInputsFromPreviousSteps(requiredKeys, optionalKeys, currentNodeInputs, outputs, previousNodeInputs, params);
            String modelName = (String)inputs.get("name");
            String modelGroupId = (String)inputs.get("model_group_id");
            String description = (String)inputs.get("description");
            String connectorId = (String)inputs.get("connector_id");
            Guardrails guardRails = (Guardrails)inputs.get("guardrails");
            String modelInterface = (String)inputs.get("interface");
            final Boolean deploy = ParseUtils.parseIfExists(inputs, "deploy", Boolean.class);
            MLRegisterModelInput.MLRegisterModelInputBuilder builder = MLRegisterModelInput.builder().functionName(FunctionName.REMOTE).modelName(modelName).connectorId(connectorId).tenantId(tenantId);
            if (modelGroupId != null) {
                builder.modelGroupId(modelGroupId);
            }
            if (description != null) {
                builder.description(description);
            }
            if (deploy != null) {
                builder.deployModel(deploy.booleanValue());
            }
            if (guardRails != null) {
                builder.guardrails(guardRails);
            }
            if (modelInterface != null) {
                try {
                    BytesArray modelInterfaceBytes = new BytesArray(modelInterface.getBytes(StandardCharsets.UTF_8));
                    Map modelInterfaceAsMap = (Map)XContentHelper.convertToMap((BytesReference)modelInterfaceBytes, (boolean)false, (MediaType)MediaTypeRegistry.JSON).v2();
                    Map<String, String> parameters = ParseUtils.convertStringToObjectMapToStringToStringMap(modelInterfaceAsMap);
                    builder.modelInterface(parameters);
                }
                catch (Exception ex) {
                    String errorMessage = "Failed to create model interface";
                    logger.error(errorMessage, (Throwable)ex);
                    registerRemoteModelFuture.onFailure((Exception)((Object)new WorkflowStepException(errorMessage, RestStatus.BAD_REQUEST)));
                }
            }
            MLRegisterModelInput mlInput = builder.build();
            this.mlClient.register(mlInput, (ActionListener)new ActionListener<MLRegisterModelResponse>(){
                final /* synthetic */ RegisterRemoteModelStep this$0;
                {
                    this.this$0 = this$0;
                }

                public void onResponse(MLRegisterModelResponse mlRegisterModelResponse) {
                    logger.info("Remote Model registration successful");
                    String resourceName = WorkflowResources.getResourceByWorkflowStep(this.this$0.getName());
                    ActionListener registerUpdateListener = ActionListener.wrap(registerUpdateResponse -> {
                        if (Boolean.TRUE.equals(deploy)) {
                            this.updateDeployResource(resourceName, mlRegisterModelResponse);
                        } else {
                            this.completeRegisterFuture(resourceName, mlRegisterModelResponse);
                        }
                    }, registerUpdateException -> {
                        String errorMessage = "Failed to update new created " + currentNodeId + " resource " + this.this$0.getName() + " id " + mlRegisterModelResponse.getModelId();
                        this.completeRegisterFutureExceptionally(errorMessage, (Exception)registerUpdateException);
                    });
                    this.this$0.flowFrameworkIndicesHandler.addResourceToStateIndex(currentNodeInputs, currentNodeId, this.this$0.getName(), mlRegisterModelResponse.getModelId(), tenantId, (ActionListener<WorkflowData>)registerUpdateListener);
                }

                private void updateDeployResource(String resourceName, MLRegisterModelResponse mlRegisterModelResponse) {
                    ActionListener deployUpdateListener = ActionListener.wrap(deployUpdateResponse -> this.completeRegisterFuture(resourceName, mlRegisterModelResponse), deployUpdateException -> {
                        String errorMessage = "Failed to update simulated deploy step resource " + mlRegisterModelResponse.getModelId();
                        this.completeRegisterFutureExceptionally(errorMessage, (Exception)deployUpdateException);
                    });
                    this.this$0.flowFrameworkIndicesHandler.addResourceToStateIndex(currentNodeInputs, currentNodeId, "deploy_model", mlRegisterModelResponse.getModelId(), tenantId, (ActionListener<WorkflowData>)deployUpdateListener);
                }

                private void completeRegisterFuture(String resourceName, MLRegisterModelResponse mlRegisterModelResponse) {
                    logger.info("successfully updated resources created in state index");
                    registerRemoteModelFuture.onResponse((Object)new WorkflowData(Map.ofEntries(Map.entry(resourceName, mlRegisterModelResponse.getModelId()), Map.entry("register_model_status", mlRegisterModelResponse.getStatus())), currentNodeInputs.getWorkflowId(), currentNodeInputs.getNodeId()));
                }

                private void completeRegisterFutureExceptionally(String errorMessage, Exception exception) {
                    logger.error(errorMessage, (Throwable)exception);
                    registerRemoteModelFuture.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)exception))));
                }

                public void onFailure(Exception ex) {
                    Exception e = WorkflowStepException.getSafeException(ex);
                    String errorMessage = e == null ? "Failed to register remote model" : e.getMessage();
                    logger.error(errorMessage, (Throwable)e);
                    registerRemoteModelFuture.onFailure((Exception)((Object)new WorkflowStepException(errorMessage, ExceptionsHelper.status((Throwable)e))));
                }
            });
        }
        catch (IllegalArgumentException iae) {
            registerRemoteModelFuture.onFailure((Exception)((Object)new WorkflowStepException(iae.getMessage(), RestStatus.BAD_REQUEST)));
        }
        catch (FlowFrameworkException e) {
            registerRemoteModelFuture.onFailure((Exception)((Object)e));
        }
        return registerRemoteModelFuture;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

