/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.model;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.flowframework.exception.FlowFrameworkException;

public class WorkflowEdge
implements ToXContentObject {
    public static final String SOURCE_FIELD = "source";
    public static final String DEST_FIELD = "dest";
    private final String source;
    private final String destination;

    public WorkflowEdge(String source, String destination) {
        this.source = source;
        this.destination = destination;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        xContentBuilder.field(SOURCE_FIELD, this.source);
        xContentBuilder.field(DEST_FIELD, this.destination);
        return xContentBuilder.endObject();
    }

    public static WorkflowEdge parse(XContentParser parser) throws IOException {
        String source = null;
        String destination = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "source": {
                    source = parser.text();
                    continue block8;
                }
                case "dest": {
                    destination = parser.text();
                    continue block8;
                }
            }
            throw new FlowFrameworkException("Unable to parse field [" + fieldName + "] in an edge object.", RestStatus.BAD_REQUEST);
        }
        if (source == null || destination == null) {
            throw new FlowFrameworkException("An edge object requires both a source and dest field.", RestStatus.BAD_REQUEST);
        }
        return new WorkflowEdge(source, destination);
    }

    public String source() {
        return this.source;
    }

    public String destination() {
        return this.destination;
    }

    public int hashCode() {
        return Objects.hash(this.destination, this.source);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorkflowEdge other = (WorkflowEdge)obj;
        return Objects.equals(this.destination, other.destination) && Objects.equals(this.source, other.source);
    }

    public String toString() {
        return this.source + "->" + this.destination;
    }
}

