/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.execution.session;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import shaded.com.google.common.collect.ImmutableList;

public enum SessionState {
    NOT_STARTED("not_started"),
    RUNNING("running"),
    DEAD("dead"),
    FAIL("fail");

    public static final List<SessionState> END_STATE;
    private final String sessionState;
    private static Map<String, SessionState> STATES;

    private SessionState(String sessionState) {
        this.sessionState = sessionState;
    }

    public static SessionState fromString(String key) {
        for (SessionState ss : SessionState.values()) {
            if (!ss.getSessionState().toLowerCase(Locale.ROOT).equals(key)) continue;
            return ss;
        }
        throw new IllegalArgumentException("Invalid session state: " + key);
    }

    @Generated
    public String getSessionState() {
        return this.sessionState;
    }

    static {
        END_STATE = ImmutableList.of((Object)((Object)DEAD), (Object)((Object)FAIL));
        STATES = Arrays.stream(SessionState.values()).collect(Collectors.toMap(t -> t.name().toLowerCase(), t -> t));
    }
}

