/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.NamedArgumentExpression;

public final class TableFunctionUtils {
    public static void validatePrometheusTableFunctionArguments(List<Expression> arguments, List<String> argumentNames) {
        Boolean argumentsPassedByName = arguments.stream().noneMatch(arg -> StringUtils.isEmpty((CharSequence)((NamedArgumentExpression)arg).getArgName()));
        Boolean argumentsPassedByPosition = arguments.stream().allMatch(arg -> StringUtils.isEmpty((CharSequence)((NamedArgumentExpression)arg).getArgName()));
        if (!argumentsPassedByName.booleanValue() && !argumentsPassedByPosition.booleanValue()) {
            throw new SemanticCheckException("Arguments should be either passed by name or position");
        }
        if (arguments.size() != argumentNames.size()) {
            throw new SemanticCheckException(TableFunctionUtils.generateErrorMessageForMissingArguments(argumentsPassedByPosition, arguments, argumentNames));
        }
    }

    public static List<Expression> getNamedArgumentsOfTableFunction(List<Expression> arguments, List<String> argumentNames) {
        boolean argumentsPassedByPosition = arguments.stream().allMatch(arg -> StringUtils.isEmpty((CharSequence)((NamedArgumentExpression)arg).getArgName()));
        if (argumentsPassedByPosition) {
            ArrayList<Expression> namedArguments = new ArrayList<Expression>();
            for (int i = 0; i < arguments.size(); ++i) {
                namedArguments.add(new NamedArgumentExpression(argumentNames.get(i), ((NamedArgumentExpression)arguments.get(i)).getValue()));
            }
            return namedArguments;
        }
        return arguments;
    }

    private static String generateErrorMessageForMissingArguments(Boolean areArgumentsPassedByPosition, List<Expression> arguments, List<String> argumentNames) {
        if (areArgumentsPassedByPosition.booleanValue()) {
            return String.format("Missing arguments:[%s]", String.join((CharSequence)",", argumentNames.subList(arguments.size(), argumentNames.size())));
        }
        HashSet<String> requiredArguments = new HashSet<String>(argumentNames);
        Set providedArguments = arguments.stream().map(expression -> ((NamedArgumentExpression)expression).getArgName()).collect(Collectors.toSet());
        requiredArguments.removeAll(providedArguments);
        return String.format("Missing arguments:[%s]", String.join((CharSequence)",", requiredArguments));
    }

    @Generated
    private TableFunctionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

