/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.functions.resolver;

import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.function.FunctionBuilder;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.expression.function.FunctionResolver;
import org.opensearch.sql.expression.function.FunctionSignature;
import org.opensearch.sql.prometheus.client.PrometheusClient;
import org.opensearch.sql.prometheus.functions.implementation.QueryExemplarFunctionImplementation;
import org.opensearch.sql.prometheus.utils.TableFunctionUtils;

public class QueryExemplarsTableFunctionResolver
implements FunctionResolver {
    private final PrometheusClient prometheusClient;
    public static final String QUERY_EXEMPLARS = "query_exemplars";
    public static final String QUERY = "query";
    public static final String STARTTIME = "starttime";
    public static final String ENDTIME = "endtime";

    @Override
    public Pair<FunctionSignature, FunctionBuilder> resolve(FunctionSignature unresolvedSignature) {
        FunctionName functionName = FunctionName.of(QUERY_EXEMPLARS);
        FunctionSignature functionSignature = new FunctionSignature(FunctionName.of(QUERY_EXEMPLARS), List.of(ExprCoreType.STRING, ExprCoreType.LONG, ExprCoreType.LONG));
        FunctionBuilder functionBuilder = (functionProperties, arguments) -> {
            List<String> argumentNames = List.of(QUERY, STARTTIME, ENDTIME);
            TableFunctionUtils.validatePrometheusTableFunctionArguments(arguments, argumentNames);
            List<Expression> namedArguments = TableFunctionUtils.getNamedArgumentsOfTableFunction(arguments, argumentNames);
            return new QueryExemplarFunctionImplementation(functionName, namedArguments, this.prometheusClient);
        };
        return Pair.of((Object)functionSignature, (Object)functionBuilder);
    }

    @Override
    public FunctionName getFunctionName() {
        return FunctionName.of(QUERY_EXEMPLARS);
    }

    @Generated
    public QueryExemplarsTableFunctionResolver(PrometheusClient prometheusClient) {
        this.prometheusClient = prometheusClient;
    }
}

