/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.sort;

import java.util.Map;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.NestedSortBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.search.sort.SortBuilders;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.sql.analysis.NestedAnalyzer;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.opensearch.data.type.OpenSearchTextType;
import shaded.com.google.common.collect.ImmutableMap;

public class SortQueryBuilder {
    private final Map<Sort.SortOrder, SortOrder> sortOrderMap = new ImmutableMap.Builder().put((Object)Sort.SortOrder.ASC, (Object)SortOrder.ASC).put((Object)Sort.SortOrder.DESC, (Object)SortOrder.DESC).build();
    private final Map<Sort.NullOrder, String> missingMap = new ImmutableMap.Builder().put((Object)Sort.NullOrder.NULL_FIRST, (Object)"_first").put((Object)Sort.NullOrder.NULL_LAST, (Object)"_last").build();

    public SortBuilder<?> build(Expression expression, Sort.SortOption option) {
        if (expression instanceof ReferenceExpression) {
            if (((ReferenceExpression)expression).getAttr().equalsIgnoreCase("_score")) {
                return SortBuilders.scoreSort().order(this.sortOrderMap.get((Object)option.getSortOrder()));
            }
            return this.fieldBuild((ReferenceExpression)expression, option);
        }
        if (NestedAnalyzer.isNestedFunction(expression).booleanValue()) {
            this.validateNestedArgs((FunctionExpression)expression);
            String orderByName = ((FunctionExpression)expression).getArguments().get(0).toString();
            ReferenceExpression path = ((FunctionExpression)expression).getArguments().size() == 2 ? (ReferenceExpression)((FunctionExpression)expression).getArguments().get(1) : NestedAnalyzer.generatePath(orderByName);
            return ((FieldSortBuilder)SortBuilders.fieldSort((String)orderByName).order(this.sortOrderMap.get((Object)option.getSortOrder()))).setNestedSort(new NestedSortBuilder(path.toString()));
        }
        throw new IllegalStateException("unsupported expression " + String.valueOf(expression.getClass()));
    }

    private void validateNestedArgs(FunctionExpression nestedFunc) {
        if (nestedFunc.getArguments().size() < 1 || nestedFunc.getArguments().size() > 2) {
            throw new IllegalArgumentException("nested function supports 2 parameters (field, path) or 1 parameter (field)");
        }
        for (Expression arg : nestedFunc.getArguments()) {
            if (arg instanceof ReferenceExpression) continue;
            throw new IllegalArgumentException(String.format("Illegal nested field name: %s", arg.toString()));
        }
    }

    private FieldSortBuilder fieldBuild(ReferenceExpression ref, Sort.SortOption option) {
        return ((FieldSortBuilder)SortBuilders.fieldSort((String)OpenSearchTextType.convertTextToKeyword(ref.getAttr(), ref.type())).order(this.sortOrderMap.get((Object)option.getSortOrder()))).missing((Object)this.missingMap.get((Object)option.getNullOrder()));
    }
}

