/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.aggregation;

import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import lombok.Generated;
import org.apache.lucene.index.LeafReaderContext;
import org.opensearch.script.AggregationScript;
import org.opensearch.search.lookup.SearchLookup;
import org.opensearch.sql.data.model.ExprNullValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.env.Environment;
import org.opensearch.sql.opensearch.data.type.OpenSearchDataType;
import org.opensearch.sql.opensearch.storage.script.core.ExpressionScript;

public class ExpressionAggregationScript
extends AggregationScript {
    private final ExpressionScript expressionScript;

    public ExpressionAggregationScript(Expression expression, SearchLookup lookup, LeafReaderContext context, Map<String, Object> params) {
        super(params, lookup, context);
        this.expressionScript = new ExpressionScript(expression);
    }

    public Object execute() {
        ExprValue expr = this.expressionScript.execute(() -> ((ExpressionAggregationScript)this).getDoc(), this::evaluateExpression);
        if (expr.type() instanceof OpenSearchDataType) {
            return expr.value();
        }
        switch ((ExprCoreType)expr.type()) {
            case TIME: {
                return ChronoUnit.MILLIS.between(LocalTime.MIN, expr.timeValue());
            }
            case DATE: 
            case TIMESTAMP: {
                return expr.timestampValue().toEpochMilli();
            }
        }
        return expr.value();
    }

    private ExprValue evaluateExpression(Expression expression, Environment<Expression, ExprValue> valueEnv) {
        ExprValue result = expression.valueOf(valueEnv);
        if (result.isNull()) {
            return ExprNullValue.of();
        }
        return result;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExpressionAggregationScript)) {
            return false;
        }
        ExpressionAggregationScript other = (ExpressionAggregationScript)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ExpressionScript this$expressionScript = this.expressionScript;
        ExpressionScript other$expressionScript = other.expressionScript;
        return !(this$expressionScript == null ? other$expressionScript != null : !((Object)this$expressionScript).equals(other$expressionScript));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExpressionAggregationScript;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExpressionScript $expressionScript = this.expressionScript;
        result = result * 59 + ($expressionScript == null ? 43 : ((Object)$expressionScript).hashCode());
        return result;
    }
}

