/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.antlr.semantic.types.base;

import java.util.Map;
import org.opensearch.sql.legacy.antlr.semantic.types.Type;
import org.opensearch.sql.legacy.antlr.semantic.types.base.BaseType;
import org.opensearch.sql.legacy.antlr.semantic.types.base.OpenSearchIndex;
import org.opensearch.sql.legacy.utils.StringUtils;
import shaded.com.google.common.collect.ImmutableMap;

public enum OpenSearchDataType implements BaseType
{
    TYPE_ERROR(new OpenSearchDataType[0]),
    UNKNOWN(new OpenSearchDataType[0]),
    SHORT(new OpenSearchDataType[0]),
    LONG(new OpenSearchDataType[0]),
    INTEGER(SHORT, LONG),
    FLOAT(INTEGER),
    DOUBLE(FLOAT),
    NUMBER(DOUBLE),
    KEYWORD(new OpenSearchDataType[0]),
    TEXT(KEYWORD),
    STRING(TEXT),
    DATE_NANOS(new OpenSearchDataType[0]),
    DATE(DATE_NANOS, STRING),
    BOOLEAN(new OpenSearchDataType[0]),
    OBJECT(new OpenSearchDataType[0]),
    NESTED(new OpenSearchDataType[0]),
    COMPLEX(OBJECT, NESTED),
    GEO_POINT(new OpenSearchDataType[0]),
    OPENSEARCH_TYPE(NUMBER, DATE, BOOLEAN, COMPLEX, GEO_POINT);

    private static final Map<String, OpenSearchDataType> ALL_BASE_TYPES;
    private OpenSearchDataType parent;

    public static OpenSearchDataType typeOf(String str) {
        return ALL_BASE_TYPES.getOrDefault(StringUtils.toUpper(str), UNKNOWN);
    }

    private OpenSearchDataType(OpenSearchDataType ... compatibleTypes) {
        for (OpenSearchDataType subType : compatibleTypes) {
            subType.parent = this;
        }
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public boolean isCompatible(Type other) {
        if (this == UNKNOWN || other == UNKNOWN) {
            return true;
        }
        if (!(other instanceof OpenSearchDataType)) {
            if (other instanceof OpenSearchIndex && ((OpenSearchIndex)other).type() == OpenSearchIndex.IndexType.NESTED_FIELD) {
                return this.isCompatible(NESTED);
            }
            return false;
        }
        OpenSearchDataType cur = (OpenSearchDataType)other;
        while (cur != null && cur != this) {
            cur = cur.parent;
        }
        return cur != null;
    }

    public String toString() {
        return "OpenSearch Data Type [" + this.getName() + "]";
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (OpenSearchDataType type : OpenSearchDataType.values()) {
            builder.put((Object)type.name(), (Object)type);
        }
        ALL_BASE_TYPES = builder.build();
    }
}

