/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.datetime;

import java.time.LocalDate;
import java.time.format.TextStyle;
import java.util.List;
import java.util.Locale;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.calcite.utils.PPLOperandTypes;
import org.opensearch.sql.calcite.utils.PPLReturnTypes;
import org.opensearch.sql.data.model.ExprDateValue;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class PeriodNameFunction
extends ImplementorUDF {
    public PeriodNameFunction(TimeUnit periodUnit) {
        super(new PeriodNameFunctionImplementor(periodUnit), NullPolicy.ANY);
        if (!periodUnit.equals((Object)TimeUnit.DAY) && !periodUnit.equals((Object)TimeUnit.MONTH)) {
            throw new IllegalArgumentException("PeriodName is only implemented for DAY and MONTH, but got: " + String.valueOf(periodUnit));
        }
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return PPLReturnTypes.STRING_FORCE_NULLABLE;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return PPLOperandTypes.DATE_OR_TIMESTAMP_OR_STRING;
    }

    public static class PeriodNameFunctionImplementor
    implements NotNullImplementor {
        private final TimeUnit periodUnit;

        public PeriodNameFunctionImplementor(TimeUnit periodUnit) {
            this.periodUnit = periodUnit;
        }

        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            ExprType dateType = OpenSearchTypeFactory.convertRelDataTypeToExprType(((RexNode)call.getOperands().getFirst()).getType());
            return Expressions.call(PeriodNameFunctionImplementor.class, (String)"name", (Expression[])new Expression[]{translatedOperands.getFirst(), Expressions.constant((Object)this.periodUnit)});
        }

        public static String name(String date, TimeUnit periodUnit) {
            LocalDate localDate = new ExprDateValue(date).dateValue();
            if (periodUnit.equals((Object)TimeUnit.MONTH)) {
                return localDate.getMonth().getDisplayName(TextStyle.FULL, Locale.getDefault());
            }
            if (periodUnit.equals((Object)TimeUnit.DAY)) {
                return localDate.getDayOfWeek().getDisplayName(TextStyle.FULL, Locale.getDefault());
            }
            throw new IllegalArgumentException("PeriodName is only implemented for DAY and MONTH, but got: " + String.valueOf(periodUnit));
        }
    }
}

