/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.datetime;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import lombok.Generated;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.opensearch.sql.calcite.utils.PPLOperandTypes;
import org.opensearch.sql.calcite.utils.PPLReturnTypes;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.calcite.utils.datetime.DateTimeConversionUtils;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprTimestampValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.datetime.DateTimeFunctions;
import org.opensearch.sql.expression.function.FunctionProperties;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class DatePartFunction
extends ImplementorUDF {
    public DatePartFunction(TimeUnit timeUnit) {
        super(new DatePartImplementor(timeUnit), NullPolicy.ANY);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return PPLReturnTypes.INTEGER_FORCE_NULLABLE;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return PPLOperandTypes.DATETIME_OR_STRING;
    }

    public static class DatePartImplementor
    implements NotNullImplementor {
        static final Set<String> TIME_UNITS = Set.of("MICROSECOND", "SECOND", "MINUTE", "HOUR");
        private final TimeUnit timeUnit;

        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> operands) {
            ConstantExpression unit = Expressions.constant((Object)this.timeUnit.name());
            List<Expression> exprOperands = UserDefinedFunctionUtils.convertToExprValues(operands, call);
            List<Expression> exprOperandsWithProperties = UserDefinedFunctionUtils.prependFunctionProperties(exprOperands, translator);
            return Expressions.call(DatePartImplementor.class, (String)"datePart", (Expression[])new Expression[]{exprOperandsWithProperties.get(0), exprOperandsWithProperties.get(1), Expressions.convert_((Expression)unit, String.class)});
        }

        public static int datePart(FunctionProperties properties, ExprValue datetime, String part) {
            if (ExprCoreType.STRING.isCompatible(datetime.type())) {
                DatePartImplementor.ensureDatetimeParsable(part, datetime.stringValue());
            }
            ExprTimestampValue candidate = DateTimeConversionUtils.forceConvertToTimestampValue(datetime, properties);
            if (datetime.type() == ExprCoreType.TIME) {
                return DateTimeFunctions.exprExtractForTime(properties, new ExprStringValue(part), candidate).integerValue();
            }
            return DateTimeFunctions.formatExtractFunction(new ExprStringValue(part), candidate).integerValue();
        }

        private static void ensureDatetimeParsable(String part, String datetime) {
            if (TIME_UNITS.contains(part = part.toUpperCase(Locale.ROOT))) {
                ExprValueUtils.fromObjectValue(datetime, ExprCoreType.TIME);
            } else {
                ExprValueUtils.fromObjectValue(datetime, ExprCoreType.DATE);
            }
        }

        @Generated
        public DatePartImplementor(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
        }
    }
}

