/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.datetime;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.Calendar;
import lombok.Generated;
import org.opensearch.sql.exception.SemanticCheckException;
import shaded.com.google.common.collect.ImmutableList;

class CalendarLookup {
    private static Calendar getCalendar(int mode, LocalDate date) {
        int day;
        if (mode < 0 || mode > 7) {
            throw new SemanticCheckException(String.format("mode:%s is invalid, please use mode value between 0-7", mode));
        }
        int n = day = mode % 2 == 0 ? 1 : 2;
        if (ImmutableList.of((Object)1, (Object)3).contains((Object)mode)) {
            return CalendarLookup.getCalendar(day, 5, date);
        }
        if (ImmutableList.of((Object)4, (Object)6).contains((Object)mode)) {
            return CalendarLookup.getCalendar(day, 4, date);
        }
        return CalendarLookup.getCalendar(day, 7, date);
    }

    private static Calendar getCalendar(int firstDayOfWeek, int minimalDaysInWeek, LocalDate date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(firstDayOfWeek);
        calendar.setMinimalDaysInFirstWeek(minimalDaysInWeek);
        calendar.set(date.getYear(), date.getMonthValue() - 1, date.getDayOfMonth());
        return calendar;
    }

    static int getWeekNumber(int mode, LocalDate date) {
        Calendar calendar = CalendarLookup.getCalendar(mode, date);
        int weekNumber = calendar.get(3);
        if (weekNumber > 51 && calendar.get(5) < 7 && Arrays.asList(0, 1, 4, 5).contains(mode)) {
            weekNumber = 0;
        }
        return weekNumber;
    }

    static int getYearNumber(int mode, LocalDate date) {
        Calendar calendar = CalendarLookup.getCalendar(mode, date);
        int weekNumber = CalendarLookup.getWeekNumber(mode, date);
        int yearNumber = calendar.get(1);
        if (weekNumber > 51 && calendar.get(5) < 7) {
            --yearNumber;
        }
        return yearNumber;
    }

    @Generated
    public CalendarLookup() {
    }
}

