/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.common.antlr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.Vocabulary;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.opensearch.sql.common.antlr.SyntaxCheckException;

public class SyntaxAnalysisErrorListener
extends BaseErrorListener {
    private static final int CONTEXT_TRUNCATION_THRESHOLD = 20;
    private static final int SUGGESTION_TRUNCATION_THRESHOLD = 5;

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        CommonTokenStream tokens = (CommonTokenStream)recognizer.getInputStream();
        Token offendingToken = (Token)offendingSymbol;
        String query = tokens.getText();
        throw new SyntaxCheckException(String.format(Locale.ROOT, "[%s] is not a valid term at this part of the query: '%s' <-- HERE. %s", this.getOffendingText(offendingToken), this.truncateQueryAtOffendingToken(query, offendingToken), this.getDetails(recognizer, msg, e)));
    }

    private String getOffendingText(Token offendingToken) {
        return offendingToken.getText();
    }

    private String truncateQueryAtOffendingToken(String query, Token offendingToken) {
        int contextStartIndex = offendingToken.getStartIndex() - 20;
        if (contextStartIndex < 3) {
            return query.substring(0, offendingToken.getStopIndex() + 1);
        }
        return "..." + query.substring(contextStartIndex, offendingToken.getStopIndex() + 1);
    }

    private List<String> topSuggestions(Recognizer<?, ?> recognizer, IntervalSet continuations) {
        Vocabulary vocab = recognizer.getVocabulary();
        ArrayList<String> tokenNames = new ArrayList<String>(5);
        Iterator iterator = continuations.toList().subList(0, Math.min(continuations.size(), 5)).iterator();
        while (iterator.hasNext()) {
            int tokenType = (Integer)iterator.next();
            tokenNames.add(vocab.getDisplayName(tokenType));
        }
        return tokenNames;
    }

    private String getDetails(Recognizer<?, ?> recognizer, String msg, RecognitionException ex) {
        if (ex == null) {
            return msg;
        }
        IntervalSet possibleContinuations = ex.getExpectedTokens();
        List<String> suggestions = this.topSuggestions(recognizer, possibleContinuations);
        StringBuilder details = new StringBuilder("Expecting ");
        if (possibleContinuations.size() > 5) {
            details.append("one of ").append(possibleContinuations.size()).append(" possible tokens. Some examples: ").append(String.join((CharSequence)", ", suggestions)).append(", ...");
        } else {
            details.append("tokens: ").append(String.join((CharSequence)", ", suggestions));
        }
        return details.toString();
    }
}

