/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.expression.QualifiedName;
import org.opensearch.sql.ast.expression.UnresolvedExpression;

public class LambdaFunction
extends UnresolvedExpression {
    private final UnresolvedExpression function;
    private final List<QualifiedName> funcArgs;

    public List<UnresolvedExpression> getChild() {
        ArrayList<UnresolvedExpression> children = new ArrayList<UnresolvedExpression>();
        children.add(this.function);
        children.addAll(this.funcArgs);
        return children;
    }

    @Override
    public <R, C> R accept(AbstractNodeVisitor<R, C> nodeVisitor, C context) {
        return nodeVisitor.visitLambdaFunction(this, context);
    }

    @Override
    public String toString() {
        return String.format("(%s) -> %s", this.funcArgs.stream().map(Object::toString).collect(Collectors.joining(", ")), this.function.toString());
    }

    @Generated
    public UnresolvedExpression getFunction() {
        return this.function;
    }

    @Generated
    public List<QualifiedName> getFuncArgs() {
        return this.funcArgs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LambdaFunction)) {
            return false;
        }
        LambdaFunction other = (LambdaFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UnresolvedExpression this$function = this.getFunction();
        UnresolvedExpression other$function = other.getFunction();
        if (this$function == null ? other$function != null : !((Object)this$function).equals(other$function)) {
            return false;
        }
        List<QualifiedName> this$funcArgs = this.getFuncArgs();
        List<QualifiedName> other$funcArgs = other.getFuncArgs();
        return !(this$funcArgs == null ? other$funcArgs != null : !((Object)this$funcArgs).equals(other$funcArgs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LambdaFunction;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UnresolvedExpression $function = this.getFunction();
        result = result * 59 + ($function == null ? 43 : ((Object)$function).hashCode());
        List<QualifiedName> $funcArgs = this.getFuncArgs();
        result = result * 59 + ($funcArgs == null ? 43 : ((Object)$funcArgs).hashCode());
        return result;
    }

    @Generated
    public LambdaFunction(UnresolvedExpression function, List<QualifiedName> funcArgs) {
        this.function = function;
        this.funcArgs = funcArgs;
    }
}

