/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.fdt;

import com.yahoo.memory.Memory;
import com.yahoo.sketches.BinomialBoundsN;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.fdt.Group;
import com.yahoo.sketches.fdt.PostProcessor;
import com.yahoo.sketches.tuple.strings.ArrayOfStringsSketch;
import java.util.List;

public class FdtSketch
extends ArrayOfStringsSketch {
    public FdtSketch(int lgK) {
        super(lgK);
    }

    FdtSketch(Memory mem) {
        super(mem);
    }

    public FdtSketch(double threshold, double rse) {
        super(FdtSketch.computeLgK(threshold, rse));
    }

    public void update(String[] tuple) {
        super.update(tuple, tuple);
    }

    public List<Group> getResult(int[] priKeyIndices, int limit, int numStdDev, char sep) {
        PostProcessor proc = new PostProcessor(this, new Group(), sep);
        return proc.getGroupList(priKeyIndices, numStdDev, limit);
    }

    public PostProcessor getPostProcessor() {
        return this.getPostProcessor(new Group(), '|');
    }

    public PostProcessor getPostProcessor(Group group, char sep) {
        return new PostProcessor(this, group, sep);
    }

    public double getEstimate(int numSubsetEntries) {
        if (!this.isEstimationMode()) {
            return numSubsetEntries;
        }
        return (double)numSubsetEntries / this.getTheta();
    }

    public double getLowerBound(int numStdDev, int numSubsetEntries) {
        if (!this.isEstimationMode()) {
            return numSubsetEntries;
        }
        return BinomialBoundsN.getLowerBound(numSubsetEntries, this.getTheta(), numStdDev, this.isEmpty());
    }

    public double getUpperBound(int numStdDev, int numSubsetEntries) {
        if (!this.isEstimationMode()) {
            return numSubsetEntries;
        }
        return BinomialBoundsN.getUpperBound(numSubsetEntries, this.getTheta(), numStdDev, this.isEmpty());
    }

    static int computeLgK(double threshold, double rse) {
        double v = Math.ceil(1.0 / (threshold * rse * rse));
        int lgK = (int)Math.ceil(Math.log(v) / Math.log(2.0));
        if (lgK > 26) {
            throw new SketchesArgumentException("Requested Sketch (LgK = " + lgK + " &gt; 2^26), either increase the threshold, the rse or both.");
        }
        return lgK;
    }
}

