/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.CheckedBiConsumer;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.DefaultObjectMapper;
import org.opensearch.security.dlic.rest.api.AbstractApiAction;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.api.RequestHandler;
import org.opensearch.security.dlic.rest.api.Responses;
import org.opensearch.security.dlic.rest.api.RestApiAdminPrivilegesEvaluator;
import org.opensearch.security.dlic.rest.api.SecurityApiDependencies;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.dlic.rest.validation.EndpointValidator;
import org.opensearch.security.dlic.rest.validation.RequestContentValidator;
import org.opensearch.security.dlic.rest.validation.ValidationResult;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.v7.ConfigV7;
import org.opensearch.security.support.SecurityJsonNode;
import org.opensearch.threadpool.ThreadPool;

public class RateLimitersApiAction
extends AbstractApiAction {
    public static final String IP_TYPE = "ip";
    public static final String USERNAME_TYPE = "username";
    public static final String NAME_JSON_PROPERTY = "name";
    public static final String TYPE_JSON_PROPERTY = "type";
    public static final String IGNORE_HOSTS_JSON_PROPERTY = "ignore_hosts";
    public static final String AUTHENTICATION_BACKEND_JSON_PROPERTY = "authentication_backend";
    public static final String ALLOWED_TRIES_JSON_PROPERTY = "allowed_tries";
    public static final String TIME_WINDOW_SECONDS_JSON_PROPERTY = "time_window_seconds";
    public static final String BLOCK_EXPIRY_JSON_PROPERTY = "block_expiry_seconds";
    public static final String MAX_BLOCKED_CLIENTS_JSON_PROPERTY = "max_blocked_clients";
    public static final String MAX_TRACKED_CLIENTS_JSON_PROPERTY = "max_tracked_clients";
    private static final List<RestHandler.Route> ROUTES = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/authfailurelisteners"), (Object)new RestHandler.Route(RestRequest.Method.DELETE, "/authfailurelisteners/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/authfailurelisteners/{name}")));
    private static final List<RestHandler.DeprecatedRoute> deprecatedRoutes = Utils.addLegacyRoutesPrefix((List<RestHandler.DeprecatedRoute>)ImmutableList.of((Object)new RestHandler.DeprecatedRoute(RestRequest.Method.GET, "/authfailurelisteners", "[_opendistro/_security] is a deprecated endpoint path. Please use _plugins/_security instead."), (Object)new RestHandler.DeprecatedRoute(RestRequest.Method.DELETE, "/authfailurelisteners/{name}", "[_opendistro/_security] is a deprecated endpoint path. Please use _plugins/_security instead."), (Object)new RestHandler.DeprecatedRoute(RestRequest.Method.PUT, "/authfailurelisteners/{name}", "[_opendistro/_security] is a deprecated endpoint path. Please use _plugins/_security instead.")));

    protected RateLimitersApiAction(ClusterService clusterService, ThreadPool threadPool, SecurityApiDependencies securityApiDependencies) {
        super(Endpoint.RATELIMITERS, clusterService, threadPool, securityApiDependencies);
        this.requestHandlersBuilder.configureRequestHandlers(this::authFailureConfigApiRequestHandlers);
    }

    public List<RestHandler.DeprecatedRoute> deprecatedRoutes() {
        return deprecatedRoutes;
    }

    @Override
    public String getName() {
        return "Rate limiter actions to retrieve / update configs.";
    }

    public List<RestHandler.Route> routes() {
        return ROUTES;
    }

    protected CType<ConfigV7> getConfigType() {
        return CType.CONFIG;
    }

    @Override
    protected EndpointValidator createEndpointValidator() {
        return new EndpointValidator(){

            @Override
            public Endpoint endpoint() {
                return RateLimitersApiAction.this.endpoint;
            }

            @Override
            public RestApiAdminPrivilegesEvaluator restApiAdminPrivilegesEvaluator() {
                return RateLimitersApiAction.this.securityApiDependencies.restApiAdminPrivilegesEvaluator();
            }

            @Override
            public RequestContentValidator createRequestContentValidator(final Object ... params) {
                return RequestContentValidator.of(new RequestContentValidator.ValidationContext(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public Object[] params() {
                        return params;
                    }

                    @Override
                    public Settings settings() {
                        return this.this$1.RateLimitersApiAction.this.securityApiDependencies.settings();
                    }

                    @Override
                    public Map<String, RequestContentValidator.DataType> allowedKeys() {
                        ImmutableMap.Builder allowedKeys = ImmutableMap.builder();
                        return allowedKeys.put((Object)RateLimitersApiAction.TYPE_JSON_PROPERTY, (Object)RequestContentValidator.DataType.STRING).put((Object)RateLimitersApiAction.IGNORE_HOSTS_JSON_PROPERTY, (Object)RequestContentValidator.DataType.ARRAY).put((Object)RateLimitersApiAction.AUTHENTICATION_BACKEND_JSON_PROPERTY, (Object)RequestContentValidator.DataType.STRING).put((Object)RateLimitersApiAction.ALLOWED_TRIES_JSON_PROPERTY, (Object)RequestContentValidator.DataType.INTEGER).put((Object)RateLimitersApiAction.TIME_WINDOW_SECONDS_JSON_PROPERTY, (Object)RequestContentValidator.DataType.INTEGER).put((Object)RateLimitersApiAction.BLOCK_EXPIRY_JSON_PROPERTY, (Object)RequestContentValidator.DataType.INTEGER).put((Object)RateLimitersApiAction.MAX_BLOCKED_CLIENTS_JSON_PROPERTY, (Object)RequestContentValidator.DataType.INTEGER).put((Object)RateLimitersApiAction.MAX_TRACKED_CLIENTS_JSON_PROPERTY, (Object)RequestContentValidator.DataType.INTEGER).build();
                    }
                });
            }
        };
    }

    private ToXContent authFailureContent(ConfigV7 config) {
        return (builder, params) -> {
            builder.startObject();
            for (String name : config.dynamic.auth_failure_listeners.getListeners().keySet()) {
                ConfigV7.AuthFailureListener listener = config.dynamic.auth_failure_listeners.getListeners().get(name);
                builder.startObject(name);
                builder.field(NAME_JSON_PROPERTY, name).field(TYPE_JSON_PROPERTY, listener.type).field(IGNORE_HOSTS_JSON_PROPERTY, listener.ignore_hosts).field(AUTHENTICATION_BACKEND_JSON_PROPERTY, listener.authentication_backend).field(ALLOWED_TRIES_JSON_PROPERTY, listener.allowed_tries).field(TIME_WINDOW_SECONDS_JSON_PROPERTY, listener.time_window_seconds).field(BLOCK_EXPIRY_JSON_PROPERTY, listener.block_expiry_seconds).field(MAX_BLOCKED_CLIENTS_JSON_PROPERTY, listener.max_blocked_clients).field(MAX_TRACKED_CLIENTS_JSON_PROPERTY, listener.max_tracked_clients);
                builder.endObject();
            }
            builder.endObject();
            return builder;
        };
    }

    private void authFailureConfigApiRequestHandlers(RequestHandler.RequestHandlersBuilder requestHandlersBuilder) {
        requestHandlersBuilder.override(RestRequest.Method.GET, (channel, request, client) -> this.loadConfiguration(this.getConfigType(), false, false).valid(configuration -> {
            ConfigV7 config = (ConfigV7)configuration.getCEntry(CType.CONFIG.toLCString());
            Responses.ok(channel, this.authFailureContent(config));
        }).error((CheckedBiConsumer<RestStatus, ToXContent, IOException>)((CheckedBiConsumer)(status, toXContent) -> Responses.response(channel, status, toXContent)))).override(RestRequest.Method.DELETE, (channel, request, client) -> this.loadConfiguration(this.getConfigType(), false, false).valid(configuration -> {
            final ConfigV7 config = (ConfigV7)configuration.getCEntry(CType.CONFIG.toLCString());
            String listenerName = request.param(NAME_JSON_PROPERTY);
            if (config.dynamic.auth_failure_listeners.getListeners().remove(listenerName) == null) {
                Responses.notFound(channel, "listener not found");
            } else {
                this.saveOrUpdateConfiguration(client, (SecurityDynamicConfiguration<?>)configuration, new AbstractApiAction.OnSucessActionListener<IndexResponse>(this, channel){
                    final /* synthetic */ RateLimitersApiAction this$0;
                    {
                        this.this$0 = this$0;
                        super(channel2);
                    }

                    public void onResponse(IndexResponse indexResponse) {
                        Responses.ok(channel, this.this$0.authFailureContent(config));
                    }
                });
            }
        }).error((CheckedBiConsumer<RestStatus, ToXContent, IOException>)((CheckedBiConsumer)(status, toXContent) -> Responses.response(channel, status, toXContent)))).override(RestRequest.Method.PUT, (channel, request, client) -> this.loadConfiguration(this.getConfigType(), false, false).valid(configuration -> {
            final ConfigV7 config = (ConfigV7)configuration.getCEntry(CType.CONFIG.toLCString());
            String listenerName = request.param(NAME_JSON_PROPERTY);
            ObjectNode body = (ObjectNode)DefaultObjectMapper.readTree(request.content().utf8ToString());
            SecurityJsonNode authFailureListener = new SecurityJsonNode((JsonNode)body);
            ValidationResult<SecurityJsonNode> validationResult = this.validateAuthFailureListener(authFailureListener, listenerName);
            if (!validationResult.isValid()) {
                Responses.badRequest(channel, validationResult.toString());
                return;
            }
            config.dynamic.auth_failure_listeners.getListeners().put(listenerName, this.createAuthFailureListenerWithDefaults(authFailureListener));
            this.saveOrUpdateConfiguration(client, (SecurityDynamicConfiguration<?>)configuration, new AbstractApiAction.OnSucessActionListener<IndexResponse>(this, channel){
                final /* synthetic */ RateLimitersApiAction this$0;
                {
                    this.this$0 = this$0;
                    super(channel2);
                }

                public void onResponse(IndexResponse indexResponse) {
                    Responses.ok(channel, this.this$0.authFailureContent(config));
                }
            });
        }).error((CheckedBiConsumer<RestStatus, ToXContent, IOException>)((CheckedBiConsumer)(status, toXContent) -> Responses.response(channel, status, toXContent))));
    }

    private ConfigV7.AuthFailureListener createAuthFailureListenerWithDefaults(SecurityJsonNode authFailureListener) {
        List<String> ignoreHosts = authFailureListener.get(IGNORE_HOSTS_JSON_PROPERTY).isNull() ? Collections.emptyList() : authFailureListener.get(IGNORE_HOSTS_JSON_PROPERTY).asList();
        return new ConfigV7.AuthFailureListener(authFailureListener.get(TYPE_JSON_PROPERTY).asString(), authFailureListener.get(AUTHENTICATION_BACKEND_JSON_PROPERTY).asString(), ignoreHosts, authFailureListener.get(ALLOWED_TRIES_JSON_PROPERTY).asInt(ConfigV7.ALLOWED_TRIES_DEFAULT), authFailureListener.get(TIME_WINDOW_SECONDS_JSON_PROPERTY).asInt(ConfigV7.TIME_WINDOW_SECONDS_DEFAULT), authFailureListener.get(BLOCK_EXPIRY_JSON_PROPERTY).asInt(ConfigV7.BLOCK_EXPIRY_SECONDS_DEFAULT), authFailureListener.get(MAX_BLOCKED_CLIENTS_JSON_PROPERTY).asInt(ConfigV7.MAX_BLOCKED_CLIENTS_DEFAULT), authFailureListener.get(MAX_TRACKED_CLIENTS_JSON_PROPERTY).asInt(ConfigV7.MAX_TRACKED_CLIENTS_DEFAULT));
    }

    private ValidationResult<SecurityJsonNode> validateAuthFailureListener(SecurityJsonNode authFailureListener, String name) {
        if (name == null) {
            return ValidationResult.error(RestStatus.BAD_REQUEST, Responses.badRequestMessage("name is required"));
        }
        if (authFailureListener.get(TYPE_JSON_PROPERTY).isNull()) {
            return ValidationResult.error(RestStatus.BAD_REQUEST, Responses.badRequestMessage("type is required"));
        }
        if (!Set.of(IP_TYPE, USERNAME_TYPE).contains(authFailureListener.get(TYPE_JSON_PROPERTY).asString())) {
            return ValidationResult.error(RestStatus.BAD_REQUEST, Responses.badRequestMessage("type must be username or ip"));
        }
        if (authFailureListener.get(TYPE_JSON_PROPERTY).asString().equals(USERNAME_TYPE) && (authFailureListener.get(AUTHENTICATION_BACKEND_JSON_PROPERTY).isNull() || !authFailureListener.get(AUTHENTICATION_BACKEND_JSON_PROPERTY).asString().equals("internal"))) {
            return ValidationResult.error(RestStatus.BAD_REQUEST, Responses.badRequestMessage("username auth failure listeners must have 'internal' authentication backend"));
        }
        if (authFailureListener.get(TYPE_JSON_PROPERTY).asString().equals(IP_TYPE) && !authFailureListener.get(AUTHENTICATION_BACKEND_JSON_PROPERTY).isNull()) {
            return ValidationResult.error(RestStatus.BAD_REQUEST, Responses.badRequestMessage("ip auth failure listeners should not have an authentication backend"));
        }
        return ValidationResult.success(authFailureListener);
    }
}

