/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.breaker;

import java.util.Optional;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.ml.breaker.ThresholdCircuitBreaker;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.monitor.jvm.JvmService;

public class MemoryCircuitBreaker
extends ThresholdCircuitBreaker<Short> {
    private static final String ML_MEMORY_CB = "Memory Circuit Breaker";
    public static final short DEFAULT_JVM_HEAP_USAGE_THRESHOLD = 85;
    private final JvmService jvmService;

    public MemoryCircuitBreaker(JvmService jvmService) {
        super((short)85);
        this.jvmService = jvmService;
    }

    public MemoryCircuitBreaker(short threshold, JvmService jvmService) {
        super(threshold);
        this.jvmService = jvmService;
    }

    public MemoryCircuitBreaker(Settings settings, ClusterService clusterService, JvmService jvmService) {
        super(Optional.ofNullable((Integer)MLCommonsSettings.ML_COMMONS_JVM_HEAP_MEM_THRESHOLD.get(settings)).map(Integer::shortValue).orElse((short)85));
        this.jvmService = jvmService;
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_JVM_HEAP_MEM_THRESHOLD, it -> super.setThreshold(it.shortValue()));
    }

    @Override
    public String getName() {
        return ML_MEMORY_CB;
    }

    @Override
    public boolean isOpen() {
        return (Short)this.getThreshold() < 100 && this.jvmService.stats().getMem().getHeapUsedPercent() > (Short)this.getThreshold();
    }
}

