/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.common;

import java.util.ArrayList;
import org.opensearch.core.common.Strings;
import org.opensearch.protobufs.BulkRequest;
import org.opensearch.protobufs.SearchRequest;
import org.opensearch.protobufs.SourceConfig;
import org.opensearch.protobufs.SourceConfigParam;
import org.opensearch.protobufs.SourceFilter;
import org.opensearch.search.fetch.subphase.FetchSourceContext;

public class FetchSourceContextProtoUtils {
    private FetchSourceContextProtoUtils() {
    }

    public static FetchSourceContext parseFromProtoRequest(BulkRequest request) {
        Boolean fetchSource = true;
        String[] sourceExcludes = null;
        String[] sourceIncludes = null;
        if (request.hasSource()) {
            switch (request.getSource().getSourceConfigParamCase()) {
                case BOOL_VALUE: {
                    fetchSource = request.getSource().getBoolValue();
                    break;
                }
                case STRING_ARRAY: {
                    sourceIncludes = (String[])request.getSource().getStringArray().getStringArrayList().toArray((Object[])new String[0]);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Invalid sourceConfig provided.");
                }
            }
        }
        if (request.getSourceIncludesList().size() > 0) {
            sourceIncludes = (String[])request.getSourceIncludesList().toArray((Object[])new String[0]);
        }
        if (request.getSourceExcludesList().size() > 0) {
            sourceExcludes = (String[])request.getSourceExcludesList().toArray((Object[])new String[0]);
        }
        if (fetchSource != null || sourceIncludes != null || sourceExcludes != null) {
            return new FetchSourceContext(fetchSource == null ? true : fetchSource, sourceIncludes, sourceExcludes);
        }
        return null;
    }

    public static FetchSourceContext parseFromProtoRequest(SearchRequest request) {
        Boolean fetchSource = null;
        String[] sourceExcludes = null;
        String[] sourceIncludes = null;
        if (request.hasSource()) {
            SourceConfigParam source = request.getSource();
            if (source.hasBoolValue()) {
                fetchSource = source.getBoolValue();
            } else {
                sourceIncludes = (String[])source.getStringArray().getStringArrayList().toArray((Object[])new String[0]);
            }
        }
        if (request.getSourceIncludesCount() > 0) {
            sourceIncludes = (String[])request.getSourceIncludesList().toArray((Object[])new String[0]);
        }
        if (request.getSourceExcludesCount() > 0) {
            sourceExcludes = (String[])request.getSourceExcludesList().toArray((Object[])new String[0]);
        }
        if (fetchSource != null || sourceIncludes != null || sourceExcludes != null) {
            return new FetchSourceContext(fetchSource == null ? true : fetchSource, sourceIncludes, sourceExcludes);
        }
        return null;
    }

    public static FetchSourceContext fromProto(SourceConfig sourceConfig) {
        boolean fetchSource = true;
        String[] includes = Strings.EMPTY_ARRAY;
        String[] excludes = Strings.EMPTY_ARRAY;
        if (sourceConfig.getSourceConfigCase() == SourceConfig.SourceConfigCase.FETCH) {
            fetchSource = sourceConfig.getFetch();
        } else if (sourceConfig.hasIncludes()) {
            ArrayList<String> list = new ArrayList<String>();
            for (String string : sourceConfig.getIncludes().getStringArrayList()) {
                list.add(string);
            }
            includes = list.toArray(new String[0]);
        } else if (sourceConfig.hasFilter()) {
            SourceFilter sourceFilter = sourceConfig.getFilter();
            if (!sourceFilter.getIncludesList().isEmpty()) {
                ArrayList<String> includesList = new ArrayList<String>();
                for (String s : sourceFilter.getIncludesList()) {
                    includesList.add(s);
                }
                includes = includesList.toArray(new String[0]);
            }
            if (!sourceFilter.getExcludesList().isEmpty()) {
                ArrayList<String> excludesList = new ArrayList<String>();
                for (String s : sourceFilter.getExcludesList()) {
                    excludesList.add(s);
                }
                excludes = excludesList.toArray(new String[0]);
            }
        }
        return new FetchSourceContext(fetchSource, includes, excludes);
    }
}

