/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.recovery;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class TranslogStatus
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, TranslogStatus> {
    @Nonnull
    private final String percent;
    private final int recovered;
    private final int total;
    private final int totalOnStart;
    @Nullable
    private final Time totalTime;
    private final long totalTimeInMillis;
    public static final JsonpDeserializer<TranslogStatus> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TranslogStatus::setupTranslogStatusDeserializer);

    private TranslogStatus(Builder builder) {
        this.percent = ApiTypeHelper.requireNonNull(builder.percent, this, "percent");
        this.recovered = ApiTypeHelper.requireNonNull(builder.recovered, this, "recovered");
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
        this.totalOnStart = ApiTypeHelper.requireNonNull(builder.totalOnStart, this, "totalOnStart");
        this.totalTime = builder.totalTime;
        this.totalTimeInMillis = ApiTypeHelper.requireNonNull(builder.totalTimeInMillis, this, "totalTimeInMillis");
    }

    public static TranslogStatus of(Function<Builder, ObjectBuilder<TranslogStatus>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String percent() {
        return this.percent;
    }

    public final int recovered() {
        return this.recovered;
    }

    public final int total() {
        return this.total;
    }

    public final int totalOnStart() {
        return this.totalOnStart;
    }

    @Nullable
    public final Time totalTime() {
        return this.totalTime;
    }

    public final long totalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("percent");
        generator.write(this.percent);
        generator.writeKey("recovered");
        generator.write(this.recovered);
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("total_on_start");
        generator.write(this.totalOnStart);
        if (this.totalTime != null) {
            generator.writeKey("total_time");
            this.totalTime.serialize(generator, mapper);
        }
        generator.writeKey("total_time_in_millis");
        generator.write(this.totalTimeInMillis);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupTranslogStatusDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::percent, JsonpDeserializer.stringDeserializer(), "percent");
        op.add(Builder::recovered, JsonpDeserializer.integerDeserializer(), "recovered");
        op.add(Builder::total, JsonpDeserializer.integerDeserializer(), "total");
        op.add(Builder::totalOnStart, JsonpDeserializer.integerDeserializer(), "total_on_start");
        op.add(Builder::totalTime, Time._DESERIALIZER, "total_time");
        op.add(Builder::totalTimeInMillis, JsonpDeserializer.longDeserializer(), "total_time_in_millis");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.percent.hashCode();
        result = 31 * result + Integer.hashCode(this.recovered);
        result = 31 * result + Integer.hashCode(this.total);
        result = 31 * result + Integer.hashCode(this.totalOnStart);
        result = 31 * result + Objects.hashCode(this.totalTime);
        result = 31 * result + Long.hashCode(this.totalTimeInMillis);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TranslogStatus other = (TranslogStatus)o;
        return this.percent.equals(other.percent) && this.recovered == other.recovered && this.total == other.total && this.totalOnStart == other.totalOnStart && Objects.equals(this.totalTime, other.totalTime) && this.totalTimeInMillis == other.totalTimeInMillis;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, TranslogStatus> {
        private String percent;
        private Integer recovered;
        private Integer total;
        private Integer totalOnStart;
        @Nullable
        private Time totalTime;
        private Long totalTimeInMillis;

        public Builder() {
        }

        private Builder(TranslogStatus o) {
            this.percent = o.percent;
            this.recovered = o.recovered;
            this.total = o.total;
            this.totalOnStart = o.totalOnStart;
            this.totalTime = o.totalTime;
            this.totalTimeInMillis = o.totalTimeInMillis;
        }

        private Builder(Builder o) {
            this.percent = o.percent;
            this.recovered = o.recovered;
            this.total = o.total;
            this.totalOnStart = o.totalOnStart;
            this.totalTime = o.totalTime;
            this.totalTimeInMillis = o.totalTimeInMillis;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder percent(String value) {
            this.percent = value;
            return this;
        }

        @Nonnull
        public final Builder recovered(int value) {
            this.recovered = value;
            return this;
        }

        @Nonnull
        public final Builder total(int value) {
            this.total = value;
            return this;
        }

        @Nonnull
        public final Builder totalOnStart(int value) {
            this.totalOnStart = value;
            return this;
        }

        @Nonnull
        public final Builder totalTime(@Nullable Time value) {
            this.totalTime = value;
            return this;
        }

        @Nonnull
        public final Builder totalTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.totalTime(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder totalTimeInMillis(long value) {
            this.totalTimeInMillis = value;
            return this;
        }

        @Override
        @Nonnull
        public TranslogStatus build() {
            this._checkSingleUse();
            return new TranslogStatus(this);
        }
    }
}

