/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.memorycontainer.memory;

import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.memorycontainer.MemoryType;

public class MemorySearchResult
implements ToXContentObject,
Writeable {
    private final String memoryId;
    private final String memory;
    private final float score;
    private final String sessionId;
    private final String agentId;
    private final String userId;
    private final MemoryType memoryType;
    private final String role;
    private final Map<String, String> tags;
    private final Instant createdTime;
    private final Instant lastUpdatedTime;

    public MemorySearchResult(String memoryId, String memory, float score, String sessionId, String agentId, String userId, MemoryType memoryType, String role, Map<String, String> tags, Instant createdTime, Instant lastUpdatedTime) {
        this.memoryId = memoryId;
        this.memory = memory;
        this.score = score;
        this.sessionId = sessionId;
        this.agentId = agentId;
        this.userId = userId;
        this.memoryType = memoryType;
        this.role = role;
        this.tags = tags;
        this.createdTime = createdTime;
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public MemorySearchResult(StreamInput in) throws IOException {
        this.memoryId = in.readString();
        this.memory = in.readString();
        this.score = in.readFloat();
        this.sessionId = in.readOptionalString();
        this.agentId = in.readOptionalString();
        this.userId = in.readOptionalString();
        String memoryTypeStr = in.readOptionalString();
        this.memoryType = memoryTypeStr != null ? MemoryType.fromString(memoryTypeStr) : null;
        this.role = in.readOptionalString();
        this.tags = in.readBoolean() ? in.readMap(StreamInput::readString, StreamInput::readString) : null;
        this.createdTime = in.readOptionalInstant();
        this.lastUpdatedTime = in.readOptionalInstant();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.memoryId);
        out.writeString(this.memory);
        out.writeFloat(this.score);
        out.writeOptionalString(this.sessionId);
        out.writeOptionalString(this.agentId);
        out.writeOptionalString(this.userId);
        out.writeOptionalString(this.memoryType != null ? this.memoryType.toString() : null);
        out.writeOptionalString(this.role);
        if (this.tags != null && !this.tags.isEmpty()) {
            out.writeBoolean(true);
            out.writeMap(this.tags, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalInstant(this.createdTime);
        out.writeOptionalInstant(this.lastUpdatedTime);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("memory_id", this.memoryId);
        builder.field("memory", this.memory);
        builder.field("_score", this.score);
        if (this.sessionId != null) {
            builder.field("session_id", this.sessionId);
        }
        if (this.agentId != null) {
            builder.field("agent_id", this.agentId);
        }
        if (this.userId != null) {
            builder.field("user_id", this.userId);
        }
        if (this.memoryType != null) {
            builder.field("memory_type", this.memoryType.toString());
        }
        if (this.role != null) {
            builder.field("role", this.role);
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            builder.field("tags", this.tags);
        }
        if (this.createdTime != null) {
            builder.field("created_time", this.createdTime.toEpochMilli());
        }
        if (this.lastUpdatedTime != null) {
            builder.field("last_updated_time", this.lastUpdatedTime.toEpochMilli());
        }
        builder.endObject();
        return builder;
    }

    @Generated
    public static MemorySearchResultBuilder builder() {
        return new MemorySearchResultBuilder();
    }

    @Generated
    public String getMemoryId() {
        return this.memoryId;
    }

    @Generated
    public String getMemory() {
        return this.memory;
    }

    @Generated
    public float getScore() {
        return this.score;
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public String getAgentId() {
        return this.agentId;
    }

    @Generated
    public String getUserId() {
        return this.userId;
    }

    @Generated
    public MemoryType getMemoryType() {
        return this.memoryType;
    }

    @Generated
    public String getRole() {
        return this.role;
    }

    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Generated
    public Instant getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public Instant getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    @Generated
    public String toString() {
        return "MemorySearchResult(memoryId=" + this.getMemoryId() + ", memory=" + this.getMemory() + ", score=" + this.getScore() + ", sessionId=" + this.getSessionId() + ", agentId=" + this.getAgentId() + ", userId=" + this.getUserId() + ", memoryType=" + String.valueOf((Object)this.getMemoryType()) + ", role=" + this.getRole() + ", tags=" + String.valueOf(this.getTags()) + ", createdTime=" + String.valueOf(this.getCreatedTime()) + ", lastUpdatedTime=" + String.valueOf(this.getLastUpdatedTime()) + ")";
    }

    @Generated
    public static class MemorySearchResultBuilder {
        @Generated
        private String memoryId;
        @Generated
        private String memory;
        @Generated
        private float score;
        @Generated
        private String sessionId;
        @Generated
        private String agentId;
        @Generated
        private String userId;
        @Generated
        private MemoryType memoryType;
        @Generated
        private String role;
        @Generated
        private Map<String, String> tags;
        @Generated
        private Instant createdTime;
        @Generated
        private Instant lastUpdatedTime;

        @Generated
        MemorySearchResultBuilder() {
        }

        @Generated
        public MemorySearchResultBuilder memoryId(String memoryId) {
            this.memoryId = memoryId;
            return this;
        }

        @Generated
        public MemorySearchResultBuilder memory(String memory) {
            this.memory = memory;
            return this;
        }

        @Generated
        public MemorySearchResultBuilder score(float score) {
            this.score = score;
            return this;
        }

        @Generated
        public MemorySearchResultBuilder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Generated
        public MemorySearchResultBuilder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        @Generated
        public MemorySearchResultBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        @Generated
        public MemorySearchResultBuilder memoryType(MemoryType memoryType) {
            this.memoryType = memoryType;
            return this;
        }

        @Generated
        public MemorySearchResultBuilder role(String role) {
            this.role = role;
            return this;
        }

        @Generated
        public MemorySearchResultBuilder tags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        @Generated
        public MemorySearchResultBuilder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @Generated
        public MemorySearchResultBuilder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Generated
        public MemorySearchResult build() {
            return new MemorySearchResult(this.memoryId, this.memory, this.score, this.sessionId, this.agentId, this.userId, this.memoryType, this.role, this.tags, this.createdTime, this.lastUpdatedTime);
        }

        @Generated
        public String toString() {
            return "MemorySearchResult.MemorySearchResultBuilder(memoryId=" + this.memoryId + ", memory=" + this.memory + ", score=" + this.score + ", sessionId=" + this.sessionId + ", agentId=" + this.agentId + ", userId=" + this.userId + ", memoryType=" + String.valueOf((Object)this.memoryType) + ", role=" + this.role + ", tags=" + String.valueOf(this.tags) + ", createdTime=" + String.valueOf(this.createdTime) + ", lastUpdatedTime=" + String.valueOf(this.lastUpdatedTime) + ")";
        }
    }
}

