/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.profile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import org.opensearch.search.profile.ProfileMetric;
import org.opensearch.search.profile.Timer;
import org.opensearch.search.profile.aggregation.AggregationTimingType;
import org.opensearch.search.profile.fetch.FetchTimingType;
import org.opensearch.search.profile.query.QueryTimingType;

public class ProfileMetricUtil {
    public static Collection<Supplier<ProfileMetric>> getQueryProfileMetrics(Collection<Supplier<ProfileMetric>> customProfileMetrics) {
        Collection<Supplier<ProfileMetric>> metrics = ProfileMetricUtil.getDefaultQueryProfileMetrics();
        metrics.addAll(customProfileMetrics);
        return metrics;
    }

    public static Collection<Supplier<ProfileMetric>> getDefaultQueryProfileMetrics() {
        ArrayList<Supplier<ProfileMetric>> metrics = new ArrayList<Supplier<ProfileMetric>>();
        for (QueryTimingType type : QueryTimingType.values()) {
            metrics.add(() -> new Timer(type.toString()));
        }
        return metrics;
    }

    public static Collection<Supplier<ProfileMetric>> getAggregationProfileMetrics() {
        ArrayList<Supplier<ProfileMetric>> metrics = new ArrayList<Supplier<ProfileMetric>>();
        for (AggregationTimingType type : AggregationTimingType.values()) {
            metrics.add(() -> new Timer(type.toString()));
        }
        return metrics;
    }

    public static Collection<Supplier<ProfileMetric>> getFetchProfileMetrics() {
        ArrayList<Supplier<ProfileMetric>> metrics = new ArrayList<Supplier<ProfileMetric>>();
        for (FetchTimingType type : FetchTimingType.values()) {
            metrics.add(() -> new Timer(type.toString()));
        }
        return metrics;
    }
}

