/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.engine;

import java.io.IOException;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentReader;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.logging.Loggers;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.recovery.RecoverySettings;
import org.opensearch.transport.TransportService;

public class MergedSegmentWarmer
implements IndexWriter.IndexReaderWarmer {
    private final TransportService transportService;
    private final RecoverySettings recoverySettings;
    private final ClusterService clusterService;
    private final IndexShard indexShard;
    private final Logger logger;

    public MergedSegmentWarmer(TransportService transportService, RecoverySettings recoverySettings, ClusterService clusterService, IndexShard indexShard) {
        this.transportService = transportService;
        this.recoverySettings = recoverySettings;
        this.clusterService = clusterService;
        this.indexShard = indexShard;
        this.logger = Loggers.getLogger(this.getClass(), indexShard.shardId(), new String[0]);
    }

    public void warm(LeafReader leafReader) throws IOException {
        assert (leafReader instanceof SegmentReader);
        assert (this.indexShard.indexSettings().isSegRepLocalEnabled() || this.indexShard.indexSettings().isRemoteStoreEnabled());
        long startTime = System.currentTimeMillis();
        SegmentCommitInfo segmentCommitInfo = ((SegmentReader)leafReader).getSegmentInfo();
        this.logger.trace(() -> new ParameterizedMessage("Warming segment: {}", (Object)segmentCommitInfo));
        this.indexShard.publishMergedSegment(segmentCommitInfo);
        this.logger.trace(() -> {
            long segmentSize = -1L;
            try {
                segmentSize = segmentCommitInfo.sizeInBytes();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return new ParameterizedMessage("Completed segment warming for {}. Size: {}B, Timing: {}ms", new Object[]{segmentCommitInfo.info.name, segmentSize, System.currentTimeMillis() - startTime});
        });
    }
}

