/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.Version;
import org.opensearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.opensearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.action.support.clustermanager.ClusterManagerNodeRequest;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.metadata.IndexTemplateMetadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentHelper;
import org.opensearch.gateway.GatewayService;
import org.opensearch.indices.IndexTemplateMissingException;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;

public class TemplateUpgradeService
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(TemplateUpgradeService.class);
    private final UnaryOperator<Map<String, IndexTemplateMetadata>> indexTemplateMetadataUpgraders;
    public final ClusterService clusterService;
    public final ThreadPool threadPool;
    public final Client client;
    final AtomicInteger upgradesInProgress = new AtomicInteger();
    private Map<String, IndexTemplateMetadata> lastTemplateMetadata;
    private static final ToXContent.Params PARAMS = new ToXContent.MapParams(Collections.singletonMap("reduce_mappings", "true"));

    public TemplateUpgradeService(Client client, ClusterService clusterService, ThreadPool threadPool, Collection<UnaryOperator<Map<String, IndexTemplateMetadata>>> indexTemplateMetadataUpgraders) {
        this.client = client;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.indexTemplateMetadataUpgraders = templates -> {
            Map upgradedTemplates = new HashMap(templates);
            for (UnaryOperator upgrader : indexTemplateMetadataUpgraders) {
                upgradedTemplates = (Map)upgrader.apply(upgradedTemplates);
            }
            return upgradedTemplates;
        };
        if (DiscoveryNode.isClusterManagerNode(clusterService.getSettings())) {
            clusterService.addListener(this);
        }
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        ClusterState state = event.state();
        if (!state.nodes().isLocalNodeElectedClusterManager()) {
            return;
        }
        if (state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        if (this.upgradesInProgress.get() > 0) {
            return;
        }
        Map<String, IndexTemplateMetadata> templates = state.getMetadata().getTemplates();
        if (templates == this.lastTemplateMetadata) {
            return;
        }
        this.lastTemplateMetadata = templates;
        Optional<Tuple<Map<String, BytesReference>, Set<String>>> changes = this.calculateTemplateChanges(templates);
        if (changes.isPresent() && this.upgradesInProgress.compareAndSet(0, ((Map)changes.get().v1()).size() + ((Set)changes.get().v2()).size() + 1)) {
            logger.info("Starting template upgrade to version {}, {} templates will be updated and {} will be removed", (Object)Version.CURRENT, (Object)((Map)changes.get().v1()).size(), (Object)((Set)changes.get().v2()).size());
            assert (this.threadPool.getThreadContext().isSystemContext());
            this.threadPool.generic().execute(() -> this.upgradeTemplates((Map)((Tuple)changes.get()).v1(), (Set)((Tuple)changes.get()).v2()));
        }
    }

    void upgradeTemplates(Map<String, BytesReference> changes, Set<String> deletions) {
        ClusterManagerNodeRequest request;
        final AtomicBoolean anyUpgradeFailed = new AtomicBoolean(false);
        if (!this.threadPool.getThreadContext().isSystemContext()) {
            throw new IllegalStateException("template updates from the template upgrade service should always happen in a system context");
        }
        for (final Map.Entry<String, BytesReference> change : changes.entrySet()) {
            request = new PutIndexTemplateRequest(change.getKey()).source(change.getValue(), MediaTypeRegistry.JSON);
            request.clusterManagerNodeTimeout(TimeValue.timeValueMinutes((long)1L));
            this.client.admin().indices().putTemplate((PutIndexTemplateRequest)request, new ActionListener<AcknowledgedResponse>(){
                final /* synthetic */ TemplateUpgradeService this$0;
                {
                    this.this$0 = this$0;
                }

                public void onResponse(AcknowledgedResponse response) {
                    if (!response.isAcknowledged()) {
                        anyUpgradeFailed.set(true);
                        logger.warn("Error updating template [{}], request was not acknowledged", change.getKey());
                    }
                    this.this$0.tryFinishUpgrade(anyUpgradeFailed);
                }

                public void onFailure(Exception e) {
                    anyUpgradeFailed.set(true);
                    logger.warn((Message)new ParameterizedMessage("Error updating template [{}]", change.getKey()), (Throwable)e);
                    this.this$0.tryFinishUpgrade(anyUpgradeFailed);
                }
            });
        }
        for (final String template : deletions) {
            request = new DeleteIndexTemplateRequest(template);
            request.clusterManagerNodeTimeout(TimeValue.timeValueMinutes((long)1L));
            this.client.admin().indices().deleteTemplate((DeleteIndexTemplateRequest)request, new ActionListener<AcknowledgedResponse>(){
                final /* synthetic */ TemplateUpgradeService this$0;
                {
                    this.this$0 = this$0;
                }

                public void onResponse(AcknowledgedResponse response) {
                    if (!response.isAcknowledged()) {
                        anyUpgradeFailed.set(true);
                        logger.warn("Error deleting template [{}], request was not acknowledged", (Object)template);
                    }
                    this.this$0.tryFinishUpgrade(anyUpgradeFailed);
                }

                public void onFailure(Exception e) {
                    anyUpgradeFailed.set(true);
                    if (!(e instanceof IndexTemplateMissingException)) {
                        logger.warn((Message)new ParameterizedMessage("Error deleting template [{}]", (Object)template), (Throwable)e);
                    }
                    this.this$0.tryFinishUpgrade(anyUpgradeFailed);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryFinishUpgrade(AtomicBoolean anyUpgradeFailed) {
        assert (this.upgradesInProgress.get() > 0);
        if (this.upgradesInProgress.decrementAndGet() == 1) {
            try {
                if (anyUpgradeFailed.get()) {
                    logger.info("Templates were partially upgraded to version {}", (Object)Version.CURRENT);
                } else {
                    logger.info("Templates were upgraded successfully to version {}", (Object)Version.CURRENT);
                }
                Map<String, IndexTemplateMetadata> upgradedTemplates = this.clusterService.state().getMetadata().getTemplates();
                boolean changesRequired = this.calculateTemplateChanges(upgradedTemplates).isPresent();
                if (changesRequired) {
                    logger.warn("Templates are still reported as out of date after the upgrade. The template upgrade will be retried.");
                }
            }
            finally {
                int noMoreUpgrades = this.upgradesInProgress.decrementAndGet();
                assert (noMoreUpgrades == 0);
            }
        }
    }

    Optional<Tuple<Map<String, BytesReference>, Set<String>>> calculateTemplateChanges(Map<String, IndexTemplateMetadata> templates) {
        HashMap<String, IndexTemplateMetadata> existingMap = new HashMap<String, IndexTemplateMetadata>();
        for (Map.Entry<String, IndexTemplateMetadata> customCursor : templates.entrySet()) {
            existingMap.put(customCursor.getKey(), customCursor.getValue());
        }
        Map upgradedMap = (Map)this.indexTemplateMetadataUpgraders.apply(existingMap);
        if (!upgradedMap.equals(existingMap)) {
            HashSet deletes = new HashSet();
            HashMap changes = new HashMap();
            existingMap.keySet().forEach(s -> {
                if (!upgradedMap.containsKey(s)) {
                    deletes.add(s);
                }
            });
            upgradedMap.forEach((key, value) -> {
                if (!value.equals(existingMap.get(key))) {
                    changes.put(key, this.toBytesReference((IndexTemplateMetadata)value));
                }
            });
            return Optional.of(new Tuple(changes, deletes));
        }
        return Optional.empty();
    }

    private BytesReference toBytesReference(IndexTemplateMetadata templateMetadata) {
        try {
            return XContentHelper.toXContent((builder, params) -> {
                IndexTemplateMetadata.Builder.toInnerXContentWithTypes(templateMetadata, builder, params);
                return builder;
            }, (MediaType)MediaTypeRegistry.JSON, (ToXContent.Params)PARAMS, (boolean)false);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot serialize template [" + templateMetadata.getName() + "]", ex);
        }
    }
}

