/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import software.amazon.cryptography.primitives.model.ECDSASignatureAlgorithm;

public class ECDSAVerifyInput {
    private final ECDSASignatureAlgorithm signatureAlgorithm;
    private final ByteBuffer verificationKey;
    private final ByteBuffer message;
    private final ByteBuffer signature;

    protected ECDSAVerifyInput(BuilderImpl builder) {
        this.signatureAlgorithm = builder.signatureAlgorithm();
        this.verificationKey = builder.verificationKey();
        this.message = builder.message();
        this.signature = builder.signature();
    }

    public ECDSASignatureAlgorithm signatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public ByteBuffer verificationKey() {
        return this.verificationKey;
    }

    public ByteBuffer message() {
        return this.message;
    }

    public ByteBuffer signature() {
        return this.signature;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ECDSASignatureAlgorithm signatureAlgorithm;
        protected ByteBuffer verificationKey;
        protected ByteBuffer message;
        protected ByteBuffer signature;

        protected BuilderImpl() {
        }

        protected BuilderImpl(ECDSAVerifyInput model) {
            this.signatureAlgorithm = model.signatureAlgorithm();
            this.verificationKey = model.verificationKey();
            this.message = model.message();
            this.signature = model.signature();
        }

        @Override
        public Builder signatureAlgorithm(ECDSASignatureAlgorithm signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
            return this;
        }

        @Override
        public ECDSASignatureAlgorithm signatureAlgorithm() {
            return this.signatureAlgorithm;
        }

        @Override
        public Builder verificationKey(ByteBuffer verificationKey) {
            this.verificationKey = verificationKey;
            return this;
        }

        @Override
        public ByteBuffer verificationKey() {
            return this.verificationKey;
        }

        @Override
        public Builder message(ByteBuffer message) {
            this.message = message;
            return this;
        }

        @Override
        public ByteBuffer message() {
            return this.message;
        }

        @Override
        public Builder signature(ByteBuffer signature) {
            this.signature = signature;
            return this;
        }

        @Override
        public ByteBuffer signature() {
            return this.signature;
        }

        @Override
        public ECDSAVerifyInput build() {
            if (Objects.isNull((Object)this.signatureAlgorithm())) {
                throw new IllegalArgumentException("Missing value for required field `signatureAlgorithm`");
            }
            if (Objects.isNull(this.verificationKey())) {
                throw new IllegalArgumentException("Missing value for required field `verificationKey`");
            }
            if (Objects.isNull(this.message())) {
                throw new IllegalArgumentException("Missing value for required field `message`");
            }
            if (Objects.isNull(this.signature())) {
                throw new IllegalArgumentException("Missing value for required field `signature`");
            }
            return new ECDSAVerifyInput(this);
        }
    }

    public static interface Builder {
        public Builder signatureAlgorithm(ECDSASignatureAlgorithm var1);

        public ECDSASignatureAlgorithm signatureAlgorithm();

        public Builder verificationKey(ByteBuffer var1);

        public ByteBuffer verificationKey();

        public Builder message(ByteBuffer var1);

        public ByteBuffer message();

        public Builder signature(ByteBuffer var1);

        public ByteBuffer signature();

        public ECDSAVerifyInput build();
    }
}

