/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsEcdhKeyring_Compile;

import Actions_Compile.DeterministicAction;
import Actions_Compile.DeterministicActionWithResult;
import AwsKmsEcdhKeyring_Compile.__default;
import BoundedInts_Compile.uint8;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.KmsEcdhStaticConfigurations;

public class OnDecryptEcdhDataKeyFilter
implements DeterministicActionWithResult<EncryptedDataKey, Boolean, Error>,
DeterministicAction<EncryptedDataKey, Result<Boolean, Error>> {
    public KmsEcdhStaticConfigurations _keyAgreementScheme = KmsEcdhStaticConfigurations.Default();
    public DafnySequence<? extends Byte> _compressedRecipientPublicKey = DafnySequence.empty(uint8._typeDescriptor());
    public DafnySequence<? extends Byte> _compressedSenderPublicKey = DafnySequence.empty(uint8._typeDescriptor());
    private static final TypeDescriptor<OnDecryptEcdhDataKeyFilter> _TYPE = TypeDescriptor.referenceWithInitializer(OnDecryptEcdhDataKeyFilter.class, () -> null);

    public void __ctor(KmsEcdhStaticConfigurations keyAgreementScheme, DafnySequence<? extends Byte> compressedRecipientPublicKey, Option<DafnySequence<? extends Byte>> compressedSenderPublicKey) {
        this._keyAgreementScheme = keyAgreementScheme;
        this._compressedRecipientPublicKey = compressedRecipientPublicKey;
        this._compressedSenderPublicKey = compressedSenderPublicKey.is_Some() ? compressedSenderPublicKey.dtor_value() : DafnySequence.empty(uint8._typeDescriptor());
    }

    @Override
    public Result<Boolean, Error> Invoke(EncryptedDataKey edk) {
        Result<Boolean, Error> res = Result.Default(TypeDescriptor.BOOLEAN, Error._typeDescriptor(), false);
        DafnySequence<? extends Byte> _0_providerInfo = edk.dtor_keyProviderInfo();
        DafnySequence<? extends Byte> _1_providerId = edk.dtor_keyProviderId();
        if (!_1_providerId.equals(Constants_Compile.__default.RAW__ECDH__PROVIDER__ID()) && !_1_providerId.equals(Constants_Compile.__default.KMS__ECDH__PROVIDER__ID())) {
            res = Result.create_Success(TypeDescriptor.BOOLEAN, Error._typeDescriptor(), false);
            return res;
        }
        Outcome<Error> _2_valueOrError0 = Outcome.Default(Error._typeDescriptor());
        _2_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Long.compareUnsigned(_0_providerInfo.cardinalityInt(), Integer.toUnsignedLong(Constants_Compile.__default.ECDH__PROVIDER__INFO__521__LEN())) <= 0 && RawECDHKeyring_Compile.__default.ValidProviderInfoLength(_0_providerInfo), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"EDK ProviderInfo longer than expected")));
        if (_2_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _2_valueOrError0.PropagateFailure(Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return res;
        }
        byte _3_keyringVersion = (Byte)_0_providerInfo.select(0);
        Outcome<Error> _4_valueOrError1 = Outcome.Default(Error._typeDescriptor());
        _4_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), DafnySequence.of((byte[])new byte[]{_3_keyringVersion}).equals(__default.AWS__KMS__ECDH__KEYRING__VERSION()), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Incorrect Keyring version found in provider info.")));
        if (_4_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _4_valueOrError1.PropagateFailure(Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return res;
        }
        int _5_recipientPublicKeyLength = StandardLibrary_mUInt_Compile.__default.SeqToUInt32((DafnySequence<? extends Byte>)_0_providerInfo.subsequence(Constants_Compile.__default.ECDH__PROVIDER__INFO__RPL__INDEX(), Constants_Compile.__default.ECDH__PROVIDER__INFO__RPK__INDEX()));
        long _6_recipientPublicKeyLengthIndex = Integer.toUnsignedLong(Constants_Compile.__default.ECDH__PROVIDER__INFO__RPK__INDEX()) + Integer.toUnsignedLong(_5_recipientPublicKeyLength);
        long _7_senderPublicKeyIndex = _6_recipientPublicKeyLengthIndex + Constants_Compile.__default.ECDH__PROVIDER__INFO__PUBLIC__KEY__LEN();
        Outcome<Error> _8_valueOrError2 = Outcome.Default(Error._typeDescriptor());
        _8_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Long.compareUnsigned(_6_recipientPublicKeyLengthIndex + 4L, _0_providerInfo.cardinalityInt()) < 0, __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Key Provider Info Serialization Error. Serialized length less than expected.")));
        if (_8_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _8_valueOrError2.PropagateFailure(Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return res;
        }
        DafnySequence _9_providerInfoRecipientPublicKey = _0_providerInfo.subsequence(Constants_Compile.__default.ECDH__PROVIDER__INFO__RPK__INDEX(), Helpers.unsignedToInt((long)_6_recipientPublicKeyLengthIndex));
        DafnySequence _10_providerInfoSenderPublicKey = _0_providerInfo.drop(_7_senderPublicKeyIndex);
        if (this.keyAgreementScheme().is_KmsPublicKeyDiscovery()) {
            res = Result.create_Success(TypeDescriptor.BOOLEAN, Error._typeDescriptor(), this.compressedRecipientPublicKey().equals((Object)_9_providerInfoRecipientPublicKey));
            return res;
        }
        res = Result.create_Success(TypeDescriptor.BOOLEAN, Error._typeDescriptor(), this.compressedSenderPublicKey().equals((Object)_10_providerInfoSenderPublicKey) && this.compressedRecipientPublicKey().equals((Object)_9_providerInfoRecipientPublicKey) || this.compressedSenderPublicKey().equals((Object)_9_providerInfoRecipientPublicKey) && this.compressedRecipientPublicKey().equals((Object)_10_providerInfoSenderPublicKey));
        return res;
    }

    public KmsEcdhStaticConfigurations keyAgreementScheme() {
        return this._keyAgreementScheme;
    }

    public DafnySequence<? extends Byte> compressedRecipientPublicKey() {
        return this._compressedRecipientPublicKey;
    }

    public DafnySequence<? extends Byte> compressedSenderPublicKey() {
        return this._compressedSenderPublicKey;
    }

    public static TypeDescriptor<OnDecryptEcdhDataKeyFilter> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsEcdhKeyring.OnDecryptEcdhDataKeyFilter";
    }
}

