/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries;

import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.forecast.indices.ForecastIndex;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.ExistsQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.model.Config;
import org.opensearch.transport.client.Client;

public class ProfileUtil {
    private static SearchRequest createADRealtimeResultRequest(String detectorId, long startTime, String resultIndex) {
        BoolQueryBuilder filterQuery = new BoolQueryBuilder();
        filterQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"detector_id", (String)detectorId));
        filterQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"execution_end_time").gte((Object)startTime));
        filterQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"anomaly_score").gt((Object)0));
        ExistsQueryBuilder taskIdExistsFilter = QueryBuilders.existsQuery((String)"task_id");
        filterQuery.mustNot((QueryBuilder)taskIdExistsFilter);
        SearchSourceBuilder source = new SearchSourceBuilder().query((QueryBuilder)filterQuery).size(1);
        SearchRequest request = new SearchRequest(new String[]{".opendistro-anomaly-results"});
        request.source(source);
        if (resultIndex != null) {
            request.indices(new String[]{resultIndex});
        }
        return request;
    }

    private static SearchRequest createForecastRealtimeResultEverRequest(String forecasterId, long startTime, String resultIndex) {
        BoolQueryBuilder filterQuery = new BoolQueryBuilder();
        filterQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"forecaster_id", (String)forecasterId));
        filterQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"execution_end_time").gte((Object)startTime));
        ExistsQueryBuilder forecastsExistFilter = QueryBuilders.existsQuery((String)"forecast_value");
        filterQuery.must((QueryBuilder)forecastsExistFilter);
        ExistsQueryBuilder taskIdExistsFilter = QueryBuilders.existsQuery((String)"task_id");
        filterQuery.mustNot((QueryBuilder)taskIdExistsFilter);
        SearchSourceBuilder source = new SearchSourceBuilder().query((QueryBuilder)filterQuery).size(1);
        SearchRequest request = new SearchRequest(new String[]{ForecastIndex.RESULT.getIndexName()});
        request.source(source);
        if (resultIndex != null) {
            request.indices(new String[]{resultIndex});
        }
        return request;
    }

    public static void confirmRealtimeResultStatus(Config config, long startTime, Client client, AnalysisType analysisType, ActionListener<SearchResponse> listener) {
        SearchRequest searchLatestResult = null;
        if (analysisType.isAD()) {
            searchLatestResult = ProfileUtil.createADRealtimeResultRequest(config.getId(), startTime, config.getCustomResultIndexPattern());
        } else if (analysisType.isForecast()) {
            searchLatestResult = ProfileUtil.createForecastRealtimeResultEverRequest(config.getId(), startTime, config.getCustomResultIndexPattern());
        } else {
            throw new IllegalArgumentException("Analysis type is not supported, type: : " + String.valueOf((Object)analysisType));
        }
        client.search(searchLatestResult, listener);
    }
}

