/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.utils;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.RestRequest;
import org.opensearch.searchrelevance.model.SearchParams;

public class ParserUtils {
    public static SearchParams parseSearchParams(RestRequest request) throws IOException {
        SearchParams.Builder builder = SearchParams.builder();
        if (request.hasContent()) {
            XContentParser parser = request.contentParser();
            XContentParser.Token token = parser.currentToken();
            if (token == null) {
                token = parser.nextToken();
            }
            if (token == XContentParser.Token.START_OBJECT) {
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token != XContentParser.Token.FIELD_NAME) continue;
                    String fieldName = parser.currentName();
                    token = parser.nextToken();
                    switch (fieldName) {
                        case "size": {
                            if (token != XContentParser.Token.VALUE_NUMBER) break;
                            builder.size(parser.intValue());
                            break;
                        }
                        case "sort": {
                            if (token != XContentParser.Token.START_OBJECT) break;
                            ParserUtils.parseSortObject(parser, builder);
                        }
                    }
                }
            }
        }
        return builder.build();
    }

    public static void parseSortObject(XContentParser parser, SearchParams.Builder builder) throws IOException {
        XContentParser.Token token;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token != XContentParser.Token.FIELD_NAME) continue;
            String sortField = parser.currentName();
            builder.sortField(sortField);
            token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) continue;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token != XContentParser.Token.FIELD_NAME || !"order".equals(parser.currentName()) || (token = parser.nextToken()) != XContentParser.Token.VALUE_STRING) continue;
                builder.sortOrder(parser.text());
            }
        }
    }

    public static List<String> convertObjToList(Map<String, Object> source, String fieldName) {
        ArrayList<String> result = new ArrayList<String>();
        Object rawList = source.get(fieldName);
        if (rawList instanceof List) {
            ((List)rawList).forEach(item -> {
                if (item instanceof String) {
                    result.add((String)item);
                }
            });
        }
        return result;
    }

    public static String convertListToSortedStr(List<String> list) {
        ArrayList<String> sortedList = new ArrayList<String>(list);
        Collections.sort(sortedList);
        return String.join((CharSequence)",", sortedList);
    }

    public static List<String> convertSortedStrToList(String str) {
        if (str == null || str.trim().isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(str.split(",")));
        Collections.sort(list);
        return list;
    }

    public static String generateUniqueId(String queryText, String compositeKey, List<String> contextFields) {
        String contextFieldsStr = contextFields != null ? String.join((CharSequence)",", contextFields) : "";
        return Base64.getUrlEncoder().encodeToString((queryText + "::" + compositeKey + "::" + contextFieldsStr).getBytes(StandardCharsets.UTF_8));
    }

    public static String combinedIndexAndDocId(String index, String docId) {
        if (index == null) {
            return docId;
        }
        return String.join((CharSequence)"::", index, docId);
    }

    public static String getDocIdFromCompositeKey(String compositeKey) {
        return compositeKey.split("::")[1];
    }
}

