/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.executors;

import java.util.concurrent.Executor;
import lombok.Generated;
import org.apache.lucene.search.TaskExecutor;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.ScalingExecutorBuilder;
import org.opensearch.threadpool.ThreadPool;

public final class SearchRelevanceExecutor {
    static final String SEARCH_RELEVANCE_EXEC_THREAD_POOL_NAME = "_plugin_search_relevance_executor";
    private static final Integer MIN_THREAD_SIZE = 2;
    private static final Integer PROCESSOR_COUNT_DIVISOR = 2;
    private static TaskExecutor taskExecutor;

    public static ExecutorBuilder<?> getExecutorBuilder(Settings settings) {
        int allocatedProcessors = OpenSearchExecutors.allocatedProcessors((Settings)settings);
        int coreThreads = Math.max(MIN_THREAD_SIZE, allocatedProcessors / 4);
        int maxThreads = Math.max(allocatedProcessors / PROCESSOR_COUNT_DIVISOR, Math.min(coreThreads * 4, 32));
        TimeValue keepAlive = TimeValue.timeValueMinutes((long)5L);
        return new ScalingExecutorBuilder(SEARCH_RELEVANCE_EXEC_THREAD_POOL_NAME, coreThreads, maxThreads, keepAlive);
    }

    public static void initialize(ThreadPool threadPool) {
        if (threadPool == null) {
            throw new IllegalArgumentException("Argument thread-pool to Search Relevance Executor cannot be null. This is required to build executor to run actions in parallel");
        }
        taskExecutor = new TaskExecutor((Executor)threadPool.executor(SEARCH_RELEVANCE_EXEC_THREAD_POOL_NAME));
    }

    public static TaskExecutor getExecutor() {
        return taskExecutor != null ? taskExecutor : new TaskExecutor(Runnable::run);
    }

    @Generated
    private SearchRelevanceExecutor() {
    }
}

