/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.memoryoptsearch.faiss;

import java.io.Closeable;
import java.io.IOException;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.ReadAdvice;
import org.apache.lucene.util.IOUtils;
import org.opensearch.knn.memoryoptsearch.VectorSearcher;
import org.opensearch.knn.memoryoptsearch.VectorSearcherFactory;
import org.opensearch.knn.memoryoptsearch.faiss.FaissMemoryOptimizedSearcher;
import org.opensearch.knn.memoryoptsearch.faiss.UnsupportedFaissIndexException;

public class FaissMemoryOptimizedSearcherFactory
implements VectorSearcherFactory {
    @Generated
    private static final Logger log = LogManager.getLogger(FaissMemoryOptimizedSearcherFactory.class);

    @Override
    public VectorSearcher createVectorSearcher(Directory directory, String fileName, FieldInfo fieldInfo) throws IOException {
        IndexInput indexInput = directory.openInput(fileName, new IOContext(IOContext.Context.DEFAULT, null, null, ReadAdvice.RANDOM));
        try {
            return new FaissMemoryOptimizedSearcher(indexInput, fieldInfo);
        }
        catch (UnsupportedFaissIndexException e) {
            try {
                IOUtils.close((Closeable[])new Closeable[]{indexInput});
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }
}

