/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jgroups.certificates;

import java.util.Objects;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.jgroups.util.FileWatcher;
import org.jgroups.util.SslContextFactory;
import org.keycloak.spi.infinispan.JGroupsCertificateProvider;

public class FileJGroupsCertificateProvider
implements JGroupsCertificateProvider {
    private final SslContextFactory.Context context;

    private FileJGroupsCertificateProvider(SslContextFactory.Context context) {
        this.context = Objects.requireNonNull(context);
    }

    public static FileJGroupsCertificateProvider create(String keyStoreFile, String keyStorePassword, String trustStoreFile, String trustStorePassword) {
        SslContextFactory.Context context = new SslContextFactory().sslProtocol("TLS").keyStoreFileName(Objects.requireNonNull(keyStoreFile)).keyStorePassword(Objects.requireNonNull(keyStorePassword)).keyStoreType("pkcs12").trustStoreFileName(Objects.requireNonNull(trustStoreFile)).trustStorePassword(Objects.requireNonNull(trustStorePassword)).trustStoreType("pkcs12").watcher(new FileWatcher()).build();
        return new FileJGroupsCertificateProvider(context);
    }

    @Override
    public KeyManager keyManager() {
        return this.context.keyManager();
    }

    @Override
    public TrustManager trustManager() {
        return this.context.trustManager();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

