/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispClass;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.StandardClass;
import org.armedbear.lisp.StructureClass;
import org.armedbear.lisp.Symbol;

public class BuiltInClass
extends LispClass {
    public static final BuiltInClass CLASS_T = BuiltInClass.addClass(Lisp.T);
    public static final BuiltInClass ARRAY = BuiltInClass.addClass(Symbol.ARRAY);
    public static final BuiltInClass BIGNUM = BuiltInClass.addClass(Symbol.BIGNUM);
    public static final BuiltInClass BASE_STRING = BuiltInClass.addClass(Symbol.BASE_STRING);
    public static final BuiltInClass BIT_VECTOR = BuiltInClass.addClass(Symbol.BIT_VECTOR);
    public static final BuiltInClass CHARACTER = BuiltInClass.addClass(Symbol.CHARACTER);
    public static final BuiltInClass COMPLEX = BuiltInClass.addClass(Symbol.COMPLEX);
    public static final BuiltInClass CONS = BuiltInClass.addClass(Symbol.CONS);
    public static final BuiltInClass DOUBLE_FLOAT = BuiltInClass.addClass(Symbol.DOUBLE_FLOAT);
    public static final BuiltInClass ENVIRONMENT = BuiltInClass.addClass(Symbol.ENVIRONMENT);
    public static final BuiltInClass FIXNUM = BuiltInClass.addClass(Symbol.FIXNUM);
    public static final BuiltInClass FLOAT = BuiltInClass.addClass(Symbol.FLOAT);
    public static final BuiltInClass FUNCTION = BuiltInClass.addClass(Symbol.FUNCTION);
    public static final BuiltInClass HASH_TABLE = BuiltInClass.addClass(Symbol.HASH_TABLE);
    public static final BuiltInClass INTEGER = BuiltInClass.addClass(Symbol.INTEGER);
    public static final BuiltInClass JAVA_OBJECT = BuiltInClass.addClass(Symbol.JAVA_OBJECT);
    public static final BuiltInClass LIST = BuiltInClass.addClass(Symbol.LIST);
    public static final BuiltInClass LOGICAL_PATHNAME = BuiltInClass.addClass(Symbol.LOGICAL_PATHNAME);
    public static final BuiltInClass MAILBOX = BuiltInClass.addClass(Symbol.MAILBOX);
    public static final BuiltInClass MUTEX = BuiltInClass.addClass(Symbol.MUTEX);
    public static final BuiltInClass NIL_VECTOR = BuiltInClass.addClass(Symbol.NIL_VECTOR);
    public static final BuiltInClass NULL = BuiltInClass.addClass(Symbol.NULL);
    public static final BuiltInClass NUMBER = BuiltInClass.addClass(Symbol.NUMBER);
    public static final BuiltInClass PACKAGE = BuiltInClass.addClass(Symbol.PACKAGE);
    public static final BuiltInClass PATHNAME = BuiltInClass.addClass(Symbol.PATHNAME);
    public static final BuiltInClass JAR_PATHNAME = BuiltInClass.addClass(Symbol.JAR_PATHNAME);
    public static final BuiltInClass URL_PATHNAME = BuiltInClass.addClass(Symbol.URL_PATHNAME);
    public static final BuiltInClass RANDOM_STATE = BuiltInClass.addClass(Symbol.RANDOM_STATE);
    public static final BuiltInClass RATIO = BuiltInClass.addClass(Symbol.RATIO);
    public static final BuiltInClass RATIONAL = BuiltInClass.addClass(Symbol.RATIONAL);
    public static final BuiltInClass READTABLE = BuiltInClass.addClass(Symbol.READTABLE);
    public static final BuiltInClass REAL = BuiltInClass.addClass(Symbol.REAL);
    public static final BuiltInClass RESTART = BuiltInClass.addClass(Symbol.RESTART);
    public static final BuiltInClass SEQUENCE = BuiltInClass.addClass(Symbol.SEQUENCE);
    public static final BuiltInClass SIMPLE_ARRAY = BuiltInClass.addClass(Symbol.SIMPLE_ARRAY);
    public static final BuiltInClass SIMPLE_BASE_STRING = BuiltInClass.addClass(Symbol.SIMPLE_BASE_STRING);
    public static final BuiltInClass SIMPLE_BIT_VECTOR = BuiltInClass.addClass(Symbol.SIMPLE_BIT_VECTOR);
    public static final BuiltInClass SIMPLE_STRING = BuiltInClass.addClass(Symbol.SIMPLE_STRING);
    public static final BuiltInClass SIMPLE_VECTOR = BuiltInClass.addClass(Symbol.SIMPLE_VECTOR);
    public static final BuiltInClass SINGLE_FLOAT = BuiltInClass.addClass(Symbol.SINGLE_FLOAT);
    public static final BuiltInClass STRING = BuiltInClass.addClass(Symbol.STRING);
    public static final BuiltInClass SYMBOL = BuiltInClass.addClass(Symbol.SYMBOL);
    public static final BuiltInClass THREAD = BuiltInClass.addClass(Symbol.THREAD);
    public static final BuiltInClass VECTOR = BuiltInClass.addClass(Symbol.VECTOR);
    public static final BuiltInClass STACK_FRAME = BuiltInClass.addClass(Symbol.STACK_FRAME);
    public static final BuiltInClass LISP_STACK_FRAME = BuiltInClass.addClass(Symbol.LISP_STACK_FRAME);
    public static final BuiltInClass JAVA_STACK_FRAME = BuiltInClass.addClass(Symbol.JAVA_STACK_FRAME);
    public static final BuiltInClass WEAK_REFERENCE = BuiltInClass.addClass(Symbol.WEAK_REFERENCE);
    public static final StructureClass STRUCTURE_OBJECT = BuiltInClass.addClass(Symbol.STRUCTURE_OBJECT, new StructureClass(Symbol.STRUCTURE_OBJECT, Lisp.list(CLASS_T, new LispObject[0])));
    public static final LispClass STREAM = BuiltInClass.addClass(Symbol.STREAM, new StructureClass(Symbol.STREAM, Lisp.list(STRUCTURE_OBJECT, new LispObject[0])));
    public static final LispClass SYSTEM_STREAM = BuiltInClass.addClass(Symbol.SYSTEM_STREAM, new StructureClass(Symbol.SYSTEM_STREAM, Lisp.list(STREAM, new LispObject[0])));
    public static final LispClass TWO_WAY_STREAM = BuiltInClass.addClass(Symbol.TWO_WAY_STREAM, new StructureClass(Symbol.TWO_WAY_STREAM, Lisp.list(SYSTEM_STREAM, new LispObject[0])));
    public static final LispClass BROADCAST_STREAM = BuiltInClass.addClass(Symbol.BROADCAST_STREAM, new StructureClass(Symbol.BROADCAST_STREAM, Lisp.list(SYSTEM_STREAM, new LispObject[0])));
    public static final LispClass ECHO_STREAM = BuiltInClass.addClass(Symbol.ECHO_STREAM, new StructureClass(Symbol.ECHO_STREAM, Lisp.list(SYSTEM_STREAM, new LispObject[0])));
    public static final LispClass CASE_FROB_STREAM = BuiltInClass.addClass(Symbol.CASE_FROB_STREAM, new StructureClass(Symbol.CASE_FROB_STREAM, Lisp.list(SYSTEM_STREAM, new LispObject[0])));
    public static final LispClass STRING_STREAM = BuiltInClass.addClass(Symbol.STRING_STREAM, new StructureClass(Symbol.STRING_STREAM, Lisp.list(SYSTEM_STREAM, new LispObject[0])));
    public static final LispClass STRING_INPUT_STREAM = BuiltInClass.addClass(Symbol.STRING_INPUT_STREAM, new StructureClass(Symbol.STRING_INPUT_STREAM, Lisp.list(STRING_STREAM, new LispObject[0])));
    public static final LispClass STRING_OUTPUT_STREAM = BuiltInClass.addClass(Symbol.STRING_OUTPUT_STREAM, new StructureClass(Symbol.STRING_OUTPUT_STREAM, Lisp.list(STRING_STREAM, new LispObject[0])));
    public static final LispClass SYNONYM_STREAM = BuiltInClass.addClass(Symbol.SYNONYM_STREAM, new StructureClass(Symbol.SYNONYM_STREAM, Lisp.list(SYSTEM_STREAM, new LispObject[0])));
    public static final LispClass FILE_STREAM = BuiltInClass.addClass(Symbol.FILE_STREAM, new StructureClass(Symbol.FILE_STREAM, Lisp.list(SYSTEM_STREAM, new LispObject[0])));
    public static final LispClass JAR_STREAM = BuiltInClass.addClass(Symbol.JAR_STREAM, new StructureClass(Symbol.JAR_STREAM, Lisp.list(SYSTEM_STREAM, new LispObject[0])));
    public static final LispClass URL_STREAM = BuiltInClass.addClass(Symbol.URL_STREAM, new StructureClass(Symbol.URL_STREAM, Lisp.list(SYSTEM_STREAM, new LispObject[0])));
    public static final LispClass CONCATENATED_STREAM = BuiltInClass.addClass(Symbol.CONCATENATED_STREAM, new StructureClass(Symbol.CONCATENATED_STREAM, Lisp.list(SYSTEM_STREAM, new LispObject[0])));
    public static final LispClass CLOS_STREAM = BuiltInClass.addClass(Symbol.CLOS_STREAM, new StructureClass(Symbol.CLOS_STREAM, Lisp.list(SYSTEM_STREAM, new LispObject[0])));
    public static final LispClass SOCKET_STREAM = BuiltInClass.addClass(Symbol.SOCKET_STREAM, new StructureClass(Symbol.SOCKET_STREAM, Lisp.list(TWO_WAY_STREAM, new LispObject[0])));
    public static final LispClass SLIME_INPUT_STREAM = BuiltInClass.addClass(Symbol.SLIME_INPUT_STREAM, new StructureClass(Symbol.SLIME_INPUT_STREAM, Lisp.list(STRING_STREAM, new LispObject[0])));
    public static final LispClass SLIME_OUTPUT_STREAM = BuiltInClass.addClass(Symbol.SLIME_OUTPUT_STREAM, new StructureClass(Symbol.SLIME_OUTPUT_STREAM, Lisp.list(STRING_STREAM, new LispObject[0])));

    private BuiltInClass(Symbol symbol) {
        super(symbol);
    }

    @Override
    public LispObject typeOf() {
        return Symbol.BUILT_IN_CLASS;
    }

    @Override
    public LispObject classOf() {
        return StandardClass.BUILT_IN_CLASS;
    }

    @Override
    public boolean isFinalized() {
        return true;
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.BUILT_IN_CLASS) {
            return Lisp.T;
        }
        if (type == StandardClass.BUILT_IN_CLASS) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    @Override
    public LispObject getDescription() {
        return new SimpleString(this.princToString());
    }

    @Override
    public String printObject() {
        return this.unreadableString(this.getName().princToString());
    }

    private static BuiltInClass addClass(Symbol symbol) {
        BuiltInClass c = new BuiltInClass(symbol);
        BuiltInClass.addClass(symbol, c);
        return c;
    }

    static {
        ARRAY.setDirectSuperclass(CLASS_T);
        ARRAY.setCPL(ARRAY, CLASS_T);
        BASE_STRING.setDirectSuperclass(STRING);
        BASE_STRING.setCPL(BASE_STRING, STRING, VECTOR, ARRAY, SEQUENCE, CLASS_T);
        BIGNUM.setDirectSuperclass(INTEGER);
        BIGNUM.setCPL(BIGNUM, INTEGER, RATIONAL, REAL, NUMBER, CLASS_T);
        BIT_VECTOR.setDirectSuperclass(VECTOR);
        BIT_VECTOR.setCPL(BIT_VECTOR, VECTOR, ARRAY, SEQUENCE, CLASS_T);
        BROADCAST_STREAM.setCPL(BROADCAST_STREAM, SYSTEM_STREAM, STREAM, STRUCTURE_OBJECT, CLASS_T);
        CASE_FROB_STREAM.setCPL(CASE_FROB_STREAM, SYSTEM_STREAM, STREAM, STRUCTURE_OBJECT, CLASS_T);
        CHARACTER.setDirectSuperclass(CLASS_T);
        CHARACTER.setCPL(CHARACTER, CLASS_T);
        CLASS_T.setCPL(CLASS_T);
        COMPLEX.setDirectSuperclass(NUMBER);
        COMPLEX.setCPL(COMPLEX, NUMBER, CLASS_T);
        CONCATENATED_STREAM.setCPL(CONCATENATED_STREAM, SYSTEM_STREAM, STREAM, STRUCTURE_OBJECT, CLASS_T);
        CONS.setDirectSuperclass(LIST);
        CONS.setCPL(CONS, LIST, SEQUENCE, CLASS_T);
        DOUBLE_FLOAT.setDirectSuperclass(FLOAT);
        DOUBLE_FLOAT.setCPL(DOUBLE_FLOAT, FLOAT, REAL, NUMBER, CLASS_T);
        ECHO_STREAM.setCPL(ECHO_STREAM, SYSTEM_STREAM, STREAM, STRUCTURE_OBJECT, CLASS_T);
        ENVIRONMENT.setDirectSuperclass(CLASS_T);
        ENVIRONMENT.setCPL(ENVIRONMENT, CLASS_T);
        FIXNUM.setDirectSuperclass(INTEGER);
        FIXNUM.setCPL(FIXNUM, INTEGER, RATIONAL, REAL, NUMBER, CLASS_T);
        FILE_STREAM.setCPL(FILE_STREAM, SYSTEM_STREAM, STREAM, STRUCTURE_OBJECT, CLASS_T);
        JAR_STREAM.setCPL(JAR_STREAM, SYSTEM_STREAM, STREAM, STRUCTURE_OBJECT, CLASS_T);
        URL_STREAM.setCPL(URL_STREAM, SYSTEM_STREAM, STREAM, STRUCTURE_OBJECT, CLASS_T);
        FLOAT.setDirectSuperclass(REAL);
        FLOAT.setCPL(FLOAT, REAL, NUMBER, CLASS_T);
        FUNCTION.setDirectSuperclass(CLASS_T);
        FUNCTION.setCPL(FUNCTION, CLASS_T);
        HASH_TABLE.setDirectSuperclass(CLASS_T);
        HASH_TABLE.setCPL(HASH_TABLE, CLASS_T);
        INTEGER.setDirectSuperclass(RATIONAL);
        INTEGER.setCPL(INTEGER, RATIONAL, REAL, NUMBER, CLASS_T);
        JAVA_OBJECT.setDirectSuperclass(CLASS_T);
        JAVA_OBJECT.setCPL(JAVA_OBJECT, CLASS_T);
        LIST.setDirectSuperclass(SEQUENCE);
        LIST.setCPL(LIST, SEQUENCE, CLASS_T);
        LOGICAL_PATHNAME.setDirectSuperclass(PATHNAME);
        LOGICAL_PATHNAME.setCPL(LOGICAL_PATHNAME, PATHNAME, CLASS_T);
        MAILBOX.setDirectSuperclass(CLASS_T);
        MAILBOX.setCPL(MAILBOX, CLASS_T);
        MUTEX.setDirectSuperclass(CLASS_T);
        MUTEX.setCPL(MUTEX, CLASS_T);
        NIL_VECTOR.setDirectSuperclass(STRING);
        NIL_VECTOR.setCPL(NIL_VECTOR, STRING, VECTOR, ARRAY, SEQUENCE, CLASS_T);
        NULL.setDirectSuperclass(LIST);
        NULL.setCPL(NULL, SYMBOL, LIST, SEQUENCE, CLASS_T);
        NUMBER.setDirectSuperclass(CLASS_T);
        NUMBER.setCPL(NUMBER, CLASS_T);
        PACKAGE.setDirectSuperclass(CLASS_T);
        PACKAGE.setCPL(PACKAGE, CLASS_T);
        PATHNAME.setDirectSuperclass(CLASS_T);
        PATHNAME.setCPL(PATHNAME, CLASS_T);
        JAR_PATHNAME.setDirectSuperclass(PATHNAME);
        JAR_PATHNAME.setCPL(JAR_PATHNAME, PATHNAME, CLASS_T);
        URL_PATHNAME.setDirectSuperclass(PATHNAME);
        URL_PATHNAME.setCPL(URL_PATHNAME, PATHNAME, CLASS_T);
        RANDOM_STATE.setDirectSuperclass(CLASS_T);
        RANDOM_STATE.setCPL(RANDOM_STATE, CLASS_T);
        RATIO.setDirectSuperclass(RATIONAL);
        RATIO.setCPL(RATIO, RATIONAL, REAL, NUMBER, CLASS_T);
        RATIONAL.setDirectSuperclass(REAL);
        RATIONAL.setCPL(RATIONAL, REAL, NUMBER, CLASS_T);
        READTABLE.setDirectSuperclass(CLASS_T);
        READTABLE.setCPL(READTABLE, CLASS_T);
        REAL.setDirectSuperclass(NUMBER);
        REAL.setCPL(REAL, NUMBER, CLASS_T);
        RESTART.setDirectSuperclass(CLASS_T);
        RESTART.setCPL(RESTART, CLASS_T);
        SEQUENCE.setDirectSuperclass(CLASS_T);
        SEQUENCE.setCPL(SEQUENCE, CLASS_T);
        SIMPLE_ARRAY.setDirectSuperclass(ARRAY);
        SIMPLE_ARRAY.setCPL(SIMPLE_ARRAY, ARRAY, CLASS_T);
        SIMPLE_BASE_STRING.setDirectSuperclasses(Lisp.list(BASE_STRING, SIMPLE_STRING));
        SIMPLE_BASE_STRING.setCPL(SIMPLE_BASE_STRING, BASE_STRING, SIMPLE_STRING, STRING, VECTOR, SIMPLE_ARRAY, ARRAY, SEQUENCE, CLASS_T);
        SIMPLE_BIT_VECTOR.setDirectSuperclasses(Lisp.list(BIT_VECTOR, SIMPLE_ARRAY));
        SIMPLE_BIT_VECTOR.setCPL(SIMPLE_BIT_VECTOR, BIT_VECTOR, VECTOR, SIMPLE_ARRAY, ARRAY, SEQUENCE, CLASS_T);
        SIMPLE_STRING.setDirectSuperclasses(Lisp.list(BASE_STRING, STRING, SIMPLE_ARRAY));
        SIMPLE_STRING.setCPL(SIMPLE_STRING, BASE_STRING, STRING, VECTOR, SIMPLE_ARRAY, ARRAY, SEQUENCE, CLASS_T);
        SIMPLE_VECTOR.setDirectSuperclasses(Lisp.list(VECTOR, SIMPLE_ARRAY));
        SIMPLE_VECTOR.setCPL(SIMPLE_VECTOR, VECTOR, SIMPLE_ARRAY, ARRAY, SEQUENCE, CLASS_T);
        SINGLE_FLOAT.setDirectSuperclass(FLOAT);
        SINGLE_FLOAT.setCPL(SINGLE_FLOAT, FLOAT, REAL, NUMBER, CLASS_T);
        SLIME_INPUT_STREAM.setCPL(SLIME_INPUT_STREAM, STRING_STREAM, SYSTEM_STREAM, STREAM, STRUCTURE_OBJECT, CLASS_T);
        SLIME_OUTPUT_STREAM.setCPL(SLIME_OUTPUT_STREAM, STRING_STREAM, SYSTEM_STREAM, STREAM, STRUCTURE_OBJECT, CLASS_T);
        SOCKET_STREAM.setCPL(SOCKET_STREAM, TWO_WAY_STREAM, SYSTEM_STREAM, STREAM, STRUCTURE_OBJECT, CLASS_T);
        STREAM.setCPL(STREAM, STRUCTURE_OBJECT, CLASS_T);
        STRING.setDirectSuperclass(VECTOR);
        STRING.setCPL(STRING, VECTOR, ARRAY, SEQUENCE, CLASS_T);
        STRING_INPUT_STREAM.setCPL(STRING_INPUT_STREAM, STRING_STREAM, SYSTEM_STREAM, STREAM, STRUCTURE_OBJECT, CLASS_T);
        STRING_OUTPUT_STREAM.setCPL(STRING_OUTPUT_STREAM, STRING_STREAM, SYSTEM_STREAM, STREAM, STRUCTURE_OBJECT, CLASS_T);
        STRING_STREAM.setCPL(STRING_STREAM, SYSTEM_STREAM, STREAM, STRUCTURE_OBJECT, CLASS_T);
        STRUCTURE_OBJECT.setCPL(STRUCTURE_OBJECT, CLASS_T);
        SYMBOL.setDirectSuperclass(CLASS_T);
        SYMBOL.setCPL(SYMBOL, CLASS_T);
        SYNONYM_STREAM.setCPL(SYNONYM_STREAM, SYSTEM_STREAM, STREAM, STRUCTURE_OBJECT, CLASS_T);
        SYSTEM_STREAM.setCPL(SYSTEM_STREAM, STREAM, STRUCTURE_OBJECT, CLASS_T);
        THREAD.setDirectSuperclass(CLASS_T);
        THREAD.setCPL(THREAD, CLASS_T);
        TWO_WAY_STREAM.setCPL(TWO_WAY_STREAM, SYSTEM_STREAM, STREAM, STRUCTURE_OBJECT, CLASS_T);
        VECTOR.setDirectSuperclasses(Lisp.list(ARRAY, SEQUENCE));
        VECTOR.setCPL(VECTOR, ARRAY, SEQUENCE, CLASS_T);
        STACK_FRAME.setDirectSuperclasses(CLASS_T);
        STACK_FRAME.setCPL(STACK_FRAME, CLASS_T);
        LISP_STACK_FRAME.setDirectSuperclasses(STACK_FRAME);
        LISP_STACK_FRAME.setCPL(LISP_STACK_FRAME, STACK_FRAME, CLASS_T);
        JAVA_STACK_FRAME.setDirectSuperclasses(STACK_FRAME);
        JAVA_STACK_FRAME.setCPL(JAVA_STACK_FRAME, STACK_FRAME, CLASS_T);
        StandardClass.initializeStandardClasses();
    }
}

