/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.util.Enumeration;
import sun.misc.FIFOQueueEnumerator;
import sun.misc.LIFOQueueEnumerator;
import sun.misc.QueueElement;

public class Queue<T> {
    int length = 0;
    QueueElement<T> head = null;
    QueueElement<T> tail = null;

    public synchronized void enqueue(T t) {
        QueueElement<T> queueElement = new QueueElement<T>(t);
        if (this.head == null) {
            this.head = queueElement;
            this.tail = queueElement;
            this.length = 1;
        } else {
            queueElement.next = this.head;
            this.head.prev = queueElement;
            this.head = queueElement;
            ++this.length;
        }
        this.notify();
    }

    public T dequeue() throws InterruptedException {
        return this.dequeue(0L);
    }

    public synchronized T dequeue(long l) throws InterruptedException {
        while (this.tail == null) {
            this.wait(l);
        }
        QueueElement<T> queueElement = this.tail;
        this.tail = queueElement.prev;
        if (this.tail == null) {
            this.head = null;
        } else {
            this.tail.next = null;
        }
        --this.length;
        return queueElement.obj;
    }

    public synchronized boolean isEmpty() {
        return this.tail == null;
    }

    public final synchronized Enumeration<T> elements() {
        return new LIFOQueueEnumerator(this);
    }

    public final synchronized Enumeration<T> reverseElements() {
        return new FIFOQueueEnumerator(this);
    }

    public synchronized void dump(String string) {
        System.err.println(">> " + string);
        System.err.println("[" + this.length + " elt(s); head = " + (this.head == null ? "null" : this.head.obj + "") + " tail = " + (this.tail == null ? "null" : this.tail.obj + ""));
        QueueElement<T> queueElement = this.head;
        QueueElement<T> queueElement2 = null;
        while (queueElement != null) {
            System.err.println("  " + queueElement);
            queueElement2 = queueElement;
            queueElement = queueElement.next;
        }
        if (queueElement2 != this.tail) {
            System.err.println("  tail != last: " + this.tail + ", " + queueElement2);
        }
        System.err.println("]");
    }
}

